/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature.decorator;

import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModWorldgen;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;

public class GoldenVineDecorator
extends TreeDecorator {
    public static final MapCodec<GoldenVineDecorator> CODEC = MapCodec.unit(() -> INSTANCE);
    public static final GoldenVineDecorator INSTANCE = new GoldenVineDecorator();

    protected TreeDecoratorType<?> type() {
        return (TreeDecoratorType)ModWorldgen.GOLDEN_VINE_DECORATOR.get();
    }

    public void place(TreeDecorator.Context context) {
        this.place(context, context.random(), (List<BlockPos>)context.leaves());
    }

    public void place(TreeDecorator.Context context, RandomSource random, List<BlockPos> leaves) {
        leaves.forEach(pos -> {
            BlockPos south;
            BlockPos north;
            BlockPos east;
            BlockPos west;
            if (random.nextInt(4) == 0 && context.isAir(west = pos.west())) {
                GoldenVineDecorator.addHangingVine(west, VineBlock.EAST, context);
            }
            if (random.nextInt(4) == 0 && context.isAir(east = pos.east())) {
                GoldenVineDecorator.addHangingVine(east, VineBlock.WEST, context);
            }
            if (random.nextInt(4) == 0 && context.isAir(north = pos.north())) {
                GoldenVineDecorator.addHangingVine(north, VineBlock.SOUTH, context);
            }
            if (random.nextInt(4) == 0 && context.isAir(south = pos.south())) {
                GoldenVineDecorator.addHangingVine(south, VineBlock.NORTH, context);
            }
        });
    }

    private static void addHangingVine(BlockPos pos, BooleanProperty property, TreeDecorator.Context context) {
        GoldenVineDecorator.addVine(context, pos, property);
        BlockPos hangpos = pos.below();
        for (int y = 4; context.isAir(hangpos) && y > 0; --y) {
            GoldenVineDecorator.addVine(context, hangpos, property);
            hangpos = hangpos.below();
        }
    }

    private static void addVine(TreeDecorator.Context context, BlockPos pos, BooleanProperty property) {
        context.setBlock(pos, (BlockState)((Block)ModBlocks.golden_vine.get()).defaultBlockState().setValue((Property)property, (Comparable)Boolean.valueOf(true)));
    }
}

