/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature.trunk;

import androsa.gaiadimension.registry.registration.ModWorldgen;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class CardinalTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<CardinalTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> CardinalTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, CardinalTrunkPlacer::new));

    public CardinalTrunkPlacer(int base, int randA, int randB) {
        super(base, randA, randB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModWorldgen.CARDINAL_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> statepos, RandomSource random, int height, BlockPos origin, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        CardinalTrunkPlacer.setDirtAt((LevelSimulatedReader)level, statepos, (RandomSource)random, (BlockPos)origin.below(), (TreeConfiguration)config);
        for (int y = 0; y <= height - 2; ++y) {
            this.placeLog(level, statepos, random, origin.above(y), config);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL.stream().toList()) {
            int x = dir.getStepX();
            int z = dir.getStepZ();
            this.placeLog(level, statepos, random, origin.offset(x, height - 2, z), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis()));
            this.placeLog(level, statepos, random, origin.offset(x, height - 1, z), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis()));
            this.placeLog(level, statepos, random, origin.offset(x += dir.getStepX(), height - 1, z += dir.getStepZ()), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis()));
            for (int i = 0; i <= 1; ++i) {
                this.placeLog(level, statepos, random, origin.offset(x += dir.getStepX(), height, z += dir.getStepZ()), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis()));
                if (i != true) continue;
                list.add(new FoliagePlacer.FoliageAttachment(origin.offset(x += dir.getStepX(), height, z += dir.getStepZ()), 0, false));
            }
        }
        return list;
    }
}

