/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature.trunk;

import androsa.gaiadimension.registry.registration.ModWorldgen;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class FourBranchTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<FourBranchTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> FourBranchTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, FourBranchTrunkPlacer::new));

    public FourBranchTrunkPlacer(int base, int randA, int randB) {
        super(base, randA, randB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModWorldgen.FOUR_BRANCH_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> statepos, RandomSource random, int height, BlockPos origin, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        FourBranchTrunkPlacer.setDirtAt((LevelSimulatedReader)level, statepos, (RandomSource)random, (BlockPos)origin.below(), (TreeConfiguration)config);
        for (int y = 0; y < height; ++y) {
            this.placeLog(level, statepos, random, origin.above(y), config);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int x = dir.getStepX();
            int z = dir.getStepZ();
            for (int y = height / 2; y < height; ++y) {
                this.placeLog(level, statepos, random, origin.offset(x, y, z), config);
                if (y == height - 1) {
                    list.add(new FoliagePlacer.FoliageAttachment(origin.offset(x, y + 1, z), 0, false));
                }
                if (y % 2 != 0) continue;
                x += dir.getStepX();
                z += dir.getStepZ();
            }
        }
        list.add(new FoliagePlacer.FoliageAttachment(origin.above(height), 0, false));
        return list;
    }
}

