/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature.trunk;

import androsa.gaiadimension.registry.registration.ModWorldgen;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class ThickTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<ThickTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> ThickTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, ThickTrunkPlacer::new));

    public ThickTrunkPlacer(int base, int randA, int randB) {
        super(base, randA, randB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModWorldgen.THICK_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> statepos, RandomSource random, int height, BlockPos origin, TreeConfiguration config) {
        ThickTrunkPlacer.setDirtAt((LevelSimulatedReader)level, statepos, (RandomSource)random, (BlockPos)origin.below(), (TreeConfiguration)config);
        for (int y = 0; y < height; ++y) {
            if (y == 0) {
                this.placeLog(level, statepos, random, origin.above(y).north(2), config);
                this.placeLog(level, statepos, random, origin.above(y).south(2), config);
                this.placeLog(level, statepos, random, origin.above(y).east(2), config);
                this.placeLog(level, statepos, random, origin.above(y).west(2), config);
            }
            if (y < height / 4) {
                this.placeLog(level, statepos, random, origin.offset(1, y, 1), config);
                this.placeLog(level, statepos, random, origin.offset(1, y, -1), config);
                this.placeLog(level, statepos, random, origin.offset(-1, y, 1), config);
                this.placeLog(level, statepos, random, origin.offset(-1, y, -1), config);
            }
            this.placeLog(level, statepos, random, origin.above(y), config);
            this.placeLog(level, statepos, random, origin.above(y).north(), config);
            this.placeLog(level, statepos, random, origin.above(y).south(), config);
            this.placeLog(level, statepos, random, origin.above(y).east(), config);
            this.placeLog(level, statepos, random, origin.above(y).west(), config);
        }
        return ImmutableList.of((Object)new FoliagePlacer.FoliageAttachment(origin.above(height), 0, false));
    }
}

