/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.feature.trunk;

import androsa.gaiadimension.registry.registration.ModWorldgen;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;

public class VaryingFourBranchTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<VaryingFourBranchTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> VaryingFourBranchTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)instance).apply((Applicative)instance, VaryingFourBranchTrunkPlacer::new));

    public VaryingFourBranchTrunkPlacer(int base, int randA, int randB) {
        super(base, randA, randB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)ModWorldgen.VARYING_FOUR_BRANCH_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader level, BiConsumer<BlockPos, BlockState> statepos, RandomSource random, int height, BlockPos origin, TreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        VaryingFourBranchTrunkPlacer.setDirtAt((LevelSimulatedReader)level, statepos, (RandomSource)random, (BlockPos)origin.below(), (TreeConfiguration)config);
        for (int y = 0; y <= height / 2; ++y) {
            this.placeLog(level, statepos, random, origin.above(y), config);
        }
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            int i;
            int x = 0;
            int z = 0;
            int offset = random.nextInt(3);
            int startY = height / 2 - offset;
            for (i = 0; i <= random.nextInt(3) + 1; ++i) {
                this.placeLog(level, statepos, random, origin.offset(x += dir.getStepX(), startY, z += dir.getStepZ()), config, state -> (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)dir.getAxis()));
            }
            for (i = startY; i <= height - offset; ++i) {
                this.placeLog(level, statepos, random, origin.offset(x, i, z), config);
            }
            list.add(new FoliagePlacer.FoliageAttachment(origin.offset(x, height - offset, z), 0, false));
        }
        return list;
    }
}

