/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure;

import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModEntities;
import androsa.gaiadimension.registry.registration.ModStructures;
import androsa.gaiadimension.world.gen.structure.pieces.MalachiteWatchtowerPieces;
import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class MalachiteWatchtowerStructure
extends Structure {
    public static final MapCodec<MalachiteWatchtowerStructure> CODEC = MalachiteWatchtowerStructure.simpleCodec(MalachiteWatchtowerStructure::new);
    public static final Map<MobCategory, StructureSpawnOverride> SPAWNS = Map.of(MobCategory.MONSTER, new StructureSpawnOverride(StructureSpawnOverride.BoundingBoxType.PIECE, WeightedRandomList.create((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)ModEntities.MALACHITE_DRONE.get(), 10, 1, 1), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.SHALURKER.get(), 5, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.ARCHAIC_WARRIOR.get(), 8, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)ModEntities.CAVERN_TICK.get(), 3, 2, 3)})));

    public MalachiteWatchtowerStructure(Structure.StructureSettings config) {
        super(config);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        BlockPos pos = this.getLowestYIn5by5BoxOffset7Blocks(context, rotation);
        return pos.getY() < 60 ? Optional.empty() : Optional.of(new Structure.GenerationStub(pos, builder -> this.generatePieces((StructurePiecesBuilder)builder, context, pos, rotation)));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context, BlockPos pos, Rotation rotation) {
        LinkedList list = Lists.newLinkedList();
        MalachiteWatchtowerPieces.buildStructure(context.structureTemplateManager(), pos, rotation, list, (RandomSource)context.random());
        list.forEach(arg_0 -> ((StructurePiecesBuilder)builder).addPiece(arg_0));
    }

    public void afterPlace(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource random, BoundingBox mbb, ChunkPos pos, PiecesContainer container) {
        BoundingBox boundingbox = container.calculateBoundingBox();
        int minY = boundingbox.minY();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = mbb.minX(); x <= mbb.maxX(); ++x) {
            block1: for (int z = mbb.minZ(); z <= mbb.maxZ(); ++z) {
                mutable.set(x, minY, z);
                if (world.isEmptyBlock((BlockPos)mutable) || !boundingbox.isInside((Vec3i)mutable) || !container.isInsidePiece((BlockPos)mutable)) continue;
                for (int lowY = minY - 1; lowY > 1; --lowY) {
                    mutable.setY(lowY);
                    if (!world.isEmptyBlock((BlockPos)mutable) && !world.getBlockState((BlockPos)mutable).liquid()) continue block1;
                    world.setBlock((BlockPos)mutable, ((Block)ModBlocks.malachite_bricks.get()).defaultBlockState(), 2);
                }
            }
        }
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.MALACHITE_WATCHTOWER_TYPE.get();
    }
}

