/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure;

import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModStructures;
import androsa.gaiadimension.world.gen.structure.pieces.MiniTowerPieces;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.PiecesContainer;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class MiniTowerStructure
extends Structure {
    public static final MapCodec<MiniTowerStructure> CODEC = MiniTowerStructure.simpleCodec(MiniTowerStructure::new);

    public MiniTowerStructure(Structure.StructureSettings config) {
        super(config);
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        return MiniTowerStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    private void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        Rotation rotation = Rotation.getRandom((RandomSource)context.random());
        BlockPos blockpos = new BlockPos(context.chunkPos().getMinBlockX(), 90, context.chunkPos().getMinBlockZ());
        MiniTowerPieces.buildStructure(context.structureTemplateManager(), blockpos, rotation, (StructurePieceAccessor)builder, (RandomSource)context.random());
    }

    public void afterPlace(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource random, BoundingBox mbb, ChunkPos pos, PiecesContainer container) {
        BoundingBox boundingbox = container.calculateBoundingBox();
        int minY = boundingbox.minY();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = mbb.minX(); x <= mbb.maxX(); ++x) {
            block1: for (int z = mbb.minZ(); z <= mbb.maxZ(); ++z) {
                mutable.set(x, minY, z);
                if (world.isEmptyBlock((BlockPos)mutable) || !boundingbox.isInside((Vec3i)mutable) || !container.isInsidePiece((BlockPos)mutable)) continue;
                for (int lowY = minY - 1; lowY > 1; --lowY) {
                    mutable.setY(lowY);
                    if (!world.isEmptyBlock((BlockPos)mutable) && !world.getBlockState((BlockPos)mutable).liquid()) continue block1;
                    world.setBlock((BlockPos)mutable, ((Block)ModBlocks.heavy_soil.get()).defaultBlockState(), 2);
                }
            }
        }
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.MINI_TOWER_TYPE.get();
    }
}

