/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.pieces;

import androsa.gaiadimension.block.BossSpawnerBlock;
import androsa.gaiadimension.block.blockentity.SmallCrateBlockEntity;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModStructures;
import androsa.gaiadimension.registry.values.GaiaChestTables;
import androsa.gaiadimension.world.gen.structure.processor.MalachiteDegradeProcessor;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class MalachiteWatchtowerPieces {
    private static final ResourceLocation foyer = MalachiteWatchtowerPieces.makePiece("foyer");
    private static final ResourceLocation floor1_1 = MalachiteWatchtowerPieces.makePiece("floor1_1");
    private static final ResourceLocation floor1_2 = MalachiteWatchtowerPieces.makePiece("floor1_2");
    private static final ResourceLocation floor1_3 = MalachiteWatchtowerPieces.makePiece("floor1_3");
    private static final ResourceLocation floor_random1 = MalachiteWatchtowerPieces.makePiece("floor_random1");
    private static final ResourceLocation floor_random2 = MalachiteWatchtowerPieces.makePiece("floor_random2");
    private static final ResourceLocation floor_random3 = MalachiteWatchtowerPieces.makePiece("floor_random3");
    private static final ResourceLocation floor_random4 = MalachiteWatchtowerPieces.makePiece("floor_random4");
    private static final ResourceLocation floor_random5 = MalachiteWatchtowerPieces.makePiece("floor_random5");
    private static final ResourceLocation floor_random1_m = MalachiteWatchtowerPieces.makePiece("floor_random1_m");
    private static final ResourceLocation floor_random2_m = MalachiteWatchtowerPieces.makePiece("floor_random2_m");
    private static final ResourceLocation floor_random3_m = MalachiteWatchtowerPieces.makePiece("floor_random3_m");
    private static final ResourceLocation floor_random4_m = MalachiteWatchtowerPieces.makePiece("floor_random4_m");
    private static final ResourceLocation floor_random5_m = MalachiteWatchtowerPieces.makePiece("floor_random5_m");
    private static final ResourceLocation roof = MalachiteWatchtowerPieces.makePiece("roof");
    private static final ResourceLocation roof_m = MalachiteWatchtowerPieces.makePiece("roof_m");
    private static final ResourceLocation[] first_floors = new ResourceLocation[]{floor1_1, floor1_2, floor1_3};
    private static final ResourceLocation[] next_floors = new ResourceLocation[]{floor_random1, floor_random2, floor_random3, floor_random4, floor_random5};
    private static final ResourceLocation[] next_floors_m = new ResourceLocation[]{floor_random1_m, floor_random2_m, floor_random3_m, floor_random4_m, floor_random5_m};
    private static final BlockPos baseCenter = new BlockPos(15, 15, 15);
    private static final BlockPos f1Center = new BlockPos(12, 11, 12);
    private static final BlockPos roofCenter = new BlockPos(16, 23, 16);
    private static final BlockPos offsetNoneBig = new BlockPos(5, 0, 6);
    private static final BlockPos offsetC90Big = new BlockPos(0, 0, 5);
    private static final BlockPos offsetC180Big = new BlockPos(1, 0, 0);
    private static final BlockPos offsetCC90Big = new BlockPos(6, 0, 1);
    private static final BlockPos offsetNoneSmall = new BlockPos(0, 0, 1);
    private static final BlockPos offsetC90Small = new BlockPos(-3, 0, 0);
    private static final BlockPos offsetC180Small = new BlockPos(-2, 0, -3);
    private static final BlockPos offsetCC90Small = new BlockPos(1, 0, -2);
    private static final ImmutableMap<Rotation, BlockPos> offsetBig = ImmutableMap.of((Object)Rotation.NONE, (Object)offsetNoneBig, (Object)Rotation.CLOCKWISE_90, (Object)offsetC90Big, (Object)Rotation.CLOCKWISE_180, (Object)offsetC180Big, (Object)Rotation.COUNTERCLOCKWISE_90, (Object)offsetCC90Big);
    private static final ImmutableMap<Rotation, BlockPos> offsetSmall = ImmutableMap.of((Object)Rotation.NONE, (Object)offsetNoneSmall, (Object)Rotation.CLOCKWISE_90, (Object)offsetC90Small, (Object)Rotation.CLOCKWISE_180, (Object)offsetC180Small, (Object)Rotation.COUNTERCLOCKWISE_90, (Object)offsetCC90Small);
    protected static final ImmutableMap<ResourceLocation, BlockPos> PIVOTS = ImmutableMap.builder().put((Object)foyer, (Object)baseCenter).put((Object)floor1_1, (Object)f1Center).put((Object)floor1_2, (Object)f1Center).put((Object)floor1_3, (Object)f1Center).put((Object)floor_random1, (Object)f1Center).put((Object)floor_random2, (Object)f1Center).put((Object)floor_random3, (Object)f1Center).put((Object)floor_random4, (Object)f1Center).put((Object)floor_random5, (Object)f1Center).put((Object)floor_random1_m, (Object)f1Center).put((Object)floor_random2_m, (Object)f1Center).put((Object)floor_random3_m, (Object)f1Center).put((Object)floor_random4_m, (Object)f1Center).put((Object)floor_random5_m, (Object)f1Center).put((Object)roof, (Object)roofCenter).put((Object)roof_m, (Object)roofCenter).build();

    public static void buildStructure(StructureTemplateManager manager, BlockPos pos, Rotation rotation, List<Piece> pieces, RandomSource random) {
        int i = 0;
        pieces.add(new Piece(manager, foyer, pos, rotation, i));
        pieces.add(new Piece(manager, first_floors[random.nextInt(first_floors.length)], pos.offset((Vec3i)offsetBig.get((Object)rotation)), rotation, i += 14));
        int r = random.nextInt(2) + 4;
        for (int f = 0; f < r; ++f) {
            i += 10;
            if (f == r - 1) {
                if (f % 2 == 0) {
                    pieces.add(new Piece(manager, roof_m, pos.offset((Vec3i)offsetSmall.get((Object)rotation)), rotation, i));
                    continue;
                }
                pieces.add(new Piece(manager, roof, pos.offset((Vec3i)offsetSmall.get((Object)rotation)), rotation, i));
                continue;
            }
            if (f % 2 == 0) {
                pieces.add(new Piece(manager, next_floors[random.nextInt(next_floors.length)], pos.offset((Vec3i)offsetBig.get((Object)rotation)), rotation, i));
                continue;
            }
            pieces.add(new Piece(manager, next_floors_m[random.nextInt(next_floors_m.length)], pos.offset((Vec3i)offsetBig.get((Object)rotation)), rotation, i));
        }
    }

    public static ResourceLocation makePiece(String part) {
        return ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("watchtower/" + part));
    }

    public static class Piece
    extends TemplateStructurePiece {
        public Piece(StructureTemplateManager manager, ResourceLocation pieceloc, BlockPos pos, Rotation rot, int offset) {
            super((StructurePieceType)ModStructures.MAWA.get(), 0, manager, pieceloc, pieceloc.toString(), Piece.loadTemplate(rot, pieceloc), Piece.loadPosition(pos, offset));
        }

        public Piece(StructureTemplateManager level, CompoundTag nbt) {
            super((StructurePieceType)ModStructures.MAWA.get(), nbt, level, rl -> Piece.loadTemplate(Rotation.valueOf((String)nbt.getString("Rot")), rl));
        }

        private static StructurePlaceSettings loadTemplate(Rotation rotation, ResourceLocation pivot) {
            return new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).setRotationPivot((BlockPos)PIVOTS.get((Object)pivot)).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK).addProcessor((StructureProcessor)new MalachiteDegradeProcessor(0.2f));
        }

        private static BlockPos loadPosition(BlockPos pos, int offset) {
            return pos.offset(0, offset, 0);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext level, CompoundTag nbt) {
            super.addAdditionalSaveData(level, nbt);
            nbt.putString("Rot", this.placeSettings.getRotation().name());
        }

        protected void handleDataMarker(String name, BlockPos pos, ServerLevelAccessor world, RandomSource random, BoundingBox mbb) {
            BlockEntity tileentity;
            if ("ChestChance".equals(name)) {
                if (random.nextDouble() > 0.5) {
                    world.setBlock(pos, ((Block)ModBlocks.crude_storage_crate.get()).defaultBlockState(), 3);
                    tileentity = world.getBlockEntity(pos);
                    if (tileentity instanceof SmallCrateBlockEntity) {
                        ((SmallCrateBlockEntity)tileentity).setLootTable(GaiaChestTables.CHESTS_MALACHITE_WATCHTOWER, random.nextLong());
                    }
                } else {
                    world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
            if ("Chest".equals(name)) {
                world.setBlock(pos, ((Block)ModBlocks.crude_storage_crate.get()).defaultBlockState(), 3);
                tileentity = world.getBlockEntity(pos);
                if (tileentity instanceof SmallCrateBlockEntity) {
                    ((SmallCrateBlockEntity)tileentity).setLootTable(GaiaChestTables.CHESTS_MALACHITE_WATCHTOWER, random.nextLong());
                }
            }
            if ("Boss".equals(name)) {
                world.setBlock(pos, ((BossSpawnerBlock)((Object)ModBlocks.malachite_guard_spawner.get())).defaultBlockState(), 3);
            }
        }
    }
}

