/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.gen.structure.pieces;

import androsa.gaiadimension.block.blockentity.SmallCrateBlockEntity;
import androsa.gaiadimension.registry.registration.ModBlocks;
import androsa.gaiadimension.registry.registration.ModStructures;
import androsa.gaiadimension.world.gen.structure.processor.BlockDegradeProcessor;
import androsa.gaiadimension.world.gen.structure.processor.MiniTowerType;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.TemplateStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class MiniTowerPieces {
    private static final ResourceLocation am_base = MiniTowerPieces.makePiece("amethyst", "base");
    private static final ResourceLocation am_floor_1 = MiniTowerPieces.makePiece("amethyst", "floor_1");
    private static final ResourceLocation am_floor_2 = MiniTowerPieces.makePiece("amethyst", "floor_2");
    private static final ResourceLocation am_roof = MiniTowerPieces.makePiece("amethyst", "roof");
    private static final ResourceLocation co_base = MiniTowerPieces.makePiece("copal", "base");
    private static final ResourceLocation co_floor_1 = MiniTowerPieces.makePiece("copal", "floor_1");
    private static final ResourceLocation co_floor_2 = MiniTowerPieces.makePiece("copal", "floor_2");
    private static final ResourceLocation co_roof = MiniTowerPieces.makePiece("copal", "roof");
    private static final ResourceLocation ja_base = MiniTowerPieces.makePiece("jade", "base");
    private static final ResourceLocation ja_floor_1 = MiniTowerPieces.makePiece("jade", "floor_1");
    private static final ResourceLocation ja_floor_2 = MiniTowerPieces.makePiece("jade", "floor_2");
    private static final ResourceLocation ja_roof = MiniTowerPieces.makePiece("jade", "roof");
    private static final ResourceLocation je_base = MiniTowerPieces.makePiece("jet", "base");
    private static final ResourceLocation je_floor_1 = MiniTowerPieces.makePiece("jet", "floor_1");
    private static final ResourceLocation je_floor_2 = MiniTowerPieces.makePiece("jet", "floor_2");
    private static final ResourceLocation je_roof = MiniTowerPieces.makePiece("jet", "roof");
    private static final ResourceLocation[] amethyst_pieces = new ResourceLocation[]{am_base, am_floor_1, am_floor_2, am_roof};
    private static final ResourceLocation[] copal_pieces = new ResourceLocation[]{co_base, co_floor_1, co_floor_2, co_roof};
    private static final ResourceLocation[] jade_pieces = new ResourceLocation[]{ja_base, ja_floor_1, ja_floor_2, ja_roof};
    private static final ResourceLocation[] jet_pieces = new ResourceLocation[]{je_base, je_floor_1, je_floor_2, je_roof};
    private static final BlockPos baseCenter = new BlockPos(8, 7, 8);
    private static final BlockPos f1Center = new BlockPos(7, 11, 7);
    private static final BlockPos f2Center = new BlockPos(7, 10, 7);
    private static final BlockPos roofCenter = new BlockPos(8, 9, 8);
    private static final BlockPos blockpos_1 = new BlockPos(0, 1, 0);
    private static final BlockPos blockpos_2 = new BlockPos(1, 0, 1);
    private static final ImmutableMap<ResourceLocation, BlockPos> PIVOTS = ImmutableMap.builder().put((Object)am_base, (Object)baseCenter).put((Object)co_base, (Object)baseCenter).put((Object)ja_base, (Object)baseCenter).put((Object)je_base, (Object)baseCenter).put((Object)am_floor_1, (Object)f1Center).put((Object)co_floor_1, (Object)f1Center).put((Object)ja_floor_1, (Object)f1Center).put((Object)je_floor_1, (Object)f1Center).put((Object)am_floor_2, (Object)f2Center).put((Object)co_floor_2, (Object)f2Center).put((Object)ja_floor_2, (Object)f2Center).put((Object)je_floor_2, (Object)f2Center).put((Object)am_roof, (Object)roofCenter).put((Object)co_roof, (Object)roofCenter).put((Object)ja_roof, (Object)roofCenter).put((Object)je_roof, (Object)roofCenter).build();
    private static final ImmutableMap<ResourceLocation, BlockPos> OFFSETS = ImmutableMap.builder().put((Object)am_base, (Object)blockpos_1).put((Object)co_base, (Object)blockpos_1).put((Object)ja_base, (Object)blockpos_1).put((Object)je_base, (Object)blockpos_1).put((Object)am_floor_1, (Object)blockpos_2).put((Object)co_floor_1, (Object)blockpos_2).put((Object)ja_floor_1, (Object)blockpos_2).put((Object)je_floor_1, (Object)blockpos_2).put((Object)am_floor_2, (Object)blockpos_2).put((Object)co_floor_2, (Object)blockpos_2).put((Object)ja_floor_2, (Object)blockpos_2).put((Object)je_floor_2, (Object)blockpos_2).put((Object)am_roof, (Object)blockpos_1).put((Object)co_roof, (Object)blockpos_1).put((Object)ja_roof, (Object)blockpos_1).put((Object)je_roof, (Object)blockpos_1).build();

    public static void buildStructure(StructureTemplateManager manager, BlockPos pos, Rotation rotation, StructurePieceAccessor pieces, RandomSource random) {
        ResourceLocation[] piecearray;
        MiniTowerType type = switch (random.nextInt(MiniTowerType.values().length)) {
            case 0 -> {
                piecearray = amethyst_pieces;
                yield MiniTowerType.AMETHYST;
            }
            case 1 -> {
                piecearray = copal_pieces;
                yield MiniTowerType.COPAL;
            }
            case 2 -> {
                piecearray = jade_pieces;
                yield MiniTowerType.JADE;
            }
            default -> {
                piecearray = jet_pieces;
                yield MiniTowerType.JET;
            }
        };
        int i = 0;
        pieces.addPiece((StructurePiece)new Piece(manager, piecearray[0], pos, rotation, type, i));
        pieces.addPiece((StructurePiece)new Piece(manager, piecearray[1], pos, rotation, type, i += 8));
        pieces.addPiece((StructurePiece)new Piece(manager, piecearray[2], pos, rotation, type, i += 11));
        pieces.addPiece((StructurePiece)new Piece(manager, piecearray[3], pos, rotation, type, i += 9));
    }

    public static ResourceLocation makePiece(String material, String part) {
        return ResourceLocation.fromNamespaceAndPath((String)"gaiadimension", (String)("minitower/" + material + "/" + part));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private final MiniTowerType towerType;

        public Piece(StructureTemplateManager manager, ResourceLocation pieceloc, BlockPos pos, Rotation rot, MiniTowerType type, int offset) {
            super((StructurePieceType)ModStructures.MITO.get(), 0, manager, pieceloc, pieceloc.toString(), Piece.loadTemplate(rot, pieceloc), Piece.loadPosition(pieceloc, pos, offset));
            this.towerType = type;
        }

        public Piece(StructureTemplateManager level, CompoundTag nbt) {
            super((StructurePieceType)ModStructures.MITO.get(), nbt, level, rl -> Piece.loadTemplate(Rotation.valueOf((String)nbt.getString("Rot")), rl));
            this.towerType = MiniTowerType.valueOf(nbt.getString("TowerType"));
        }

        private static StructurePlaceSettings loadTemplate(Rotation rotation, ResourceLocation pivot) {
            return new StructurePlaceSettings().setRotation(rotation).setMirror(Mirror.NONE).setRotationPivot((BlockPos)PIVOTS.get((Object)pivot)).addProcessor((StructureProcessor)BlockIgnoreProcessor.STRUCTURE_BLOCK);
        }

        private static BlockPos loadPosition(ResourceLocation rl, BlockPos pos, int offset) {
            return pos.offset((Vec3i)OFFSETS.get((Object)rl)).above(offset);
        }

        protected void addAdditionalSaveData(StructurePieceSerializationContext level, CompoundTag nbt) {
            super.addAdditionalSaveData(level, nbt);
            nbt.putString("Rot", this.placeSettings.getRotation().name());
            nbt.putString("TowerType", this.towerType.toString());
        }

        protected void handleDataMarker(String name, BlockPos pos, ServerLevelAccessor world, RandomSource random, BoundingBox mbb) {
            if ("Chest".equals(name)) {
                if (random.nextDouble() > 0.5) {
                    world.setBlock(pos, ((Block)ModBlocks.crude_storage_crate.get()).defaultBlockState(), 3);
                    BlockEntity tileentity = world.getBlockEntity(pos);
                    if (tileentity instanceof SmallCrateBlockEntity) {
                        ((SmallCrateBlockEntity)tileentity).setLootTable(this.towerType.getChestLoot(), random.nextLong());
                    }
                } else {
                    world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }

        public void postProcess(WorldGenLevel world, StructureManager manager, ChunkGenerator generator, RandomSource random, BoundingBox mbb, ChunkPos chunkpos, BlockPos pos) {
            ResourceLocation location = ResourceLocation.parse((String)this.templateName);
            switch (this.towerType) {
                case AMETHYST: {
                    this.placeSettings.addProcessor((StructureProcessor)BlockDegradeProcessor.AMETHYST_DECAY);
                    break;
                }
                case COPAL: {
                    this.placeSettings.addProcessor((StructureProcessor)BlockDegradeProcessor.COPAL_DECAY);
                    break;
                }
                case JADE: {
                    this.placeSettings.addProcessor((StructureProcessor)BlockDegradeProcessor.JADE_DECAY);
                    break;
                }
                case JET: {
                    this.placeSettings.addProcessor((StructureProcessor)BlockDegradeProcessor.JET_DECAY);
                }
            }
            BlockPos offsetpos = (BlockPos)OFFSETS.get((Object)location);
            BlockPos tempoffset = this.templatePosition.offset((Vec3i)StructureTemplate.calculateRelativePosition((StructurePlaceSettings)this.placeSettings, (BlockPos)new BlockPos(3 - offsetpos.getX(), 0, -offsetpos.getZ())));
            int height = world.getHeight(Heightmap.Types.WORLD_SURFACE_WG, tempoffset.getX(), tempoffset.getZ());
            BlockPos temppos = this.templatePosition;
            this.templatePosition = this.templatePosition.offset(0, height - 90 - 1, 0);
            super.postProcess(world, manager, generator, random, mbb, chunkpos, pos);
            this.templatePosition = temppos;
        }
    }
}

