/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer;

import androsa.gaiadimension.registry.bootstrap.GaiaBiomes;
import androsa.gaiadimension.world.layer.GaiaLayerUtil;
import androsa.gaiadimension.world.layer.util.C0Transformer;
import androsa.gaiadimension.world.layer.util.Context;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;

public class GaiaBiomesLayer
implements C0Transformer {
    private final HolderGetter<Biome> registry;
    private static final int UNCOMMON_BIOME_CHANCE = 8;
    private static final int RARE_BIOME_CHANCE = 16;
    protected List<ResourceKey<Biome>> commonBiomes = ImmutableList.of(GaiaBiomes.pink_agate_forest, GaiaBiomes.blue_agate_taiga, GaiaBiomes.green_agate_jungle, GaiaBiomes.crystal_plains, GaiaBiomes.fossil_woodland);
    protected List<ResourceKey<Biome>> uncommonBiomes = ImmutableList.of(GaiaBiomes.volcanic_lands, GaiaBiomes.static_wasteland, GaiaBiomes.salt_dunes, GaiaBiomes.smoldering_bog, GaiaBiomes.shining_grove, GaiaBiomes.mookaite_mesa);
    protected List<ResourceKey<Biome>> rareBiomes = ImmutableList.of(GaiaBiomes.purple_agate_swamp, GaiaBiomes.goldstone_lands, GaiaBiomes.mutant_agate_wildwood);
    protected List<ResourceKey<Biome>> goldBiomes = ImmutableList.of(GaiaBiomes.golden_sands, GaiaBiomes.golden_marsh, GaiaBiomes.golden_hills, GaiaBiomes.golden_forest, GaiaBiomes.golden_plains);

    public GaiaBiomesLayer(HolderGetter<Biome> registry) {
        this.registry = registry;
    }

    @Override
    public int apply(Context context, int biome) {
        if (!this.isOcean(biome)) {
            if (this.isGold(biome)) {
                return GaiaLayerUtil.getBiomeId(this.goldBiomes.get(context.nextRandom(this.goldBiomes.size())), this.registry);
            }
            if (context.nextRandom(16) == 0) {
                return GaiaLayerUtil.getBiomeId(this.rareBiomes.get(context.nextRandom(this.rareBiomes.size())), this.registry);
            }
            if (context.nextRandom(8) == 0) {
                return GaiaLayerUtil.getBiomeId(this.uncommonBiomes.get(context.nextRandom(this.uncommonBiomes.size())), this.registry);
            }
            return GaiaLayerUtil.getBiomeId(this.commonBiomes.get(context.nextRandom(this.commonBiomes.size())), this.registry);
        }
        return biome;
    }

    private boolean isOcean(int biome) {
        return biome == GaiaLayerUtil.getBiomeId(GaiaBiomes.mineral_reservoir, this.registry) || biome == 0;
    }

    private boolean isGold(int biome) {
        return biome == GaiaLayerUtil.getBiomeId(GaiaBiomes.golden_sands, this.registry) || biome == GaiaLayerUtil.getBiomeId(GaiaBiomes.golden_marsh, this.registry) || biome == GaiaLayerUtil.getBiomeId(GaiaBiomes.golden_hills, this.registry) || biome == GaiaLayerUtil.getBiomeId(GaiaBiomes.golden_forest, this.registry) || biome == GaiaLayerUtil.getBiomeId(GaiaBiomes.golden_plains, this.registry);
    }
}

