/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer;

import androsa.gaiadimension.world.layer.AddIslandLayer;
import androsa.gaiadimension.world.layer.GaiaBiomesLayer;
import androsa.gaiadimension.world.layer.GoldIslandLayer;
import androsa.gaiadimension.world.layer.IslandLayer;
import androsa.gaiadimension.world.layer.MineralRiverLayer;
import androsa.gaiadimension.world.layer.MineralRiverMixLayer;
import androsa.gaiadimension.world.layer.OceanLayer;
import androsa.gaiadimension.world.layer.OceanMixerLayer;
import androsa.gaiadimension.world.layer.RemoveTooMuchOceanLayer;
import androsa.gaiadimension.world.layer.SmoothLayer;
import androsa.gaiadimension.world.layer.ZoomLayer;
import androsa.gaiadimension.world.layer.util.Area;
import androsa.gaiadimension.world.layer.util.AreaFactory;
import androsa.gaiadimension.world.layer.util.BigContext;
import androsa.gaiadimension.world.layer.util.Layer;
import androsa.gaiadimension.world.layer.util.LazyArea;
import androsa.gaiadimension.world.layer.util.LazyAreaContext;
import java.util.function.LongFunction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class GaiaLayerUtil {
    static int getBiomeId(ResourceKey<Biome> define, HolderGetter<Biome> registry) {
        return ServerLifecycleHooks.getCurrentServer().registryAccess().lookupOrThrow(Registries.BIOME).getId((Object)((Biome)((Holder.Reference)registry.get(define).get()).value()));
    }

    public static <T extends Area, C extends BigContext<T>> AreaFactory<T> makeLayers(LongFunction<C> contextFactory, HolderGetter<Biome> registry) {
        AreaFactory islands = IslandLayer.INSTANCE.run((BigContext)contextFactory.apply(1L));
        islands = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2000L), islands);
        islands = AddIslandLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(1L), islands);
        islands = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2001L), islands);
        islands = AddIslandLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(2L), islands);
        islands = AddIslandLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(50L), islands);
        islands = AddIslandLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(70L), islands);
        islands = RemoveTooMuchOceanLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(2L), islands);
        AreaFactory ocean = OceanLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(2L));
        ocean = ZoomLayer.FUZZY.run((BigContext)contextFactory.apply(2001L), ocean);
        ocean = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2002L), ocean);
        ocean = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2003L), ocean);
        ocean = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2004L), ocean);
        ocean = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2005L), ocean);
        ocean = SmoothLayer.INSTANCE.run((BigContext)contextFactory.apply(1003L), ocean);
        islands = AddIslandLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(3L), islands);
        islands = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2002L), islands);
        islands = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(2003L), islands);
        islands = AddIslandLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(4L), islands);
        islands = GoldIslandLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(5L), islands);
        islands = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(1000L), islands);
        AreaFactory biomes = new GaiaBiomesLayer(registry).run((BigContext)contextFactory.apply(1L), islands);
        biomes = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(1000L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(1001L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(1002L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(1003L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(1004L), biomes);
        biomes = ZoomLayer.NORMAL.run((BigContext)contextFactory.apply(1005L), biomes);
        AreaFactory river = MineralRiverLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(1L), biomes);
        river = SmoothLayer.INSTANCE.run((BigContext)contextFactory.apply(1000L), river);
        biomes = SmoothLayer.INSTANCE.run((BigContext)contextFactory.apply(1000L), biomes);
        biomes = MineralRiverMixLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(100L), biomes, river);
        return OceanMixerLayer.INSTANCE.setup(registry).run((BigContext)contextFactory.apply(100L), biomes, ocean);
    }

    public static Layer makeLayers(long seed, HolderGetter<Biome> registry) {
        AreaFactory<LazyArea> areaFactory = GaiaLayerUtil.makeLayers(contextSeed -> new LazyAreaContext(25, seed, contextSeed), registry);
        return new Layer(areaFactory);
    }
}

