/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer.util;

import androsa.gaiadimension.GaiaDimensionMod;
import androsa.gaiadimension.world.layer.util.AreaFactory;
import androsa.gaiadimension.world.layer.util.LazyArea;
import java.util.Optional;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class Layer {
    public final LazyArea area;

    public Layer(AreaFactory<LazyArea> area) {
        this.area = area.make();
    }

    public Holder<Biome> get(HolderGetter<Biome> registry, int x, int z) {
        int i = this.area.get(x, z);
        Optional biome = ServerLifecycleHooks.getCurrentServer().registryAccess().lookupOrThrow(Registries.BIOME).get(i);
        if (biome.isEmpty()) {
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                throw (IllegalStateException)Util.pauseInIde((Throwable)new IllegalStateException("Unknown biome id: " + i));
            }
            GaiaDimensionMod.LOGGER.warn("Unknown biome id: " + i);
            return registry.getOrThrow(Biomes.OCEAN);
        }
        return (Holder)biome.get();
    }
}

