/*
 * Decompiled with CFR 0.152.
 */
package androsa.gaiadimension.world.layer.util;

import androsa.gaiadimension.world.layer.util.BigContext;
import androsa.gaiadimension.world.layer.util.LazyArea;
import androsa.gaiadimension.world.layer.util.PixelTransformer;
import it.unimi.dsi.fastutil.longs.Long2IntLinkedOpenHashMap;
import net.minecraft.util.LinearCongruentialGenerator;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.ImprovedNoise;

public class LazyAreaContext
implements BigContext<LazyArea> {
    private final Long2IntLinkedOpenHashMap cache;
    private final int maxCache;
    private final ImprovedNoise biomeNoise;
    private final long seed;
    private long rval;

    public LazyAreaContext(int pMaxCache, long pSeed, long pSeedModifier) {
        this.seed = LazyAreaContext.mixSeed(pSeed, pSeedModifier);
        this.biomeNoise = new ImprovedNoise((RandomSource)new LegacyRandomSource(pSeed));
        this.cache = new Long2IntLinkedOpenHashMap(16, 0.25f);
        this.cache.defaultReturnValue(Integer.MIN_VALUE);
        this.maxCache = pMaxCache;
    }

    @Override
    public LazyArea createResult(PixelTransformer pPixelTransformer) {
        return new LazyArea(this.cache, this.maxCache, pPixelTransformer);
    }

    @Override
    public LazyArea createResult(PixelTransformer pPixelTransformer, LazyArea pArea) {
        return new LazyArea(this.cache, Math.min(1024, pArea.getMaxCache() * 4), pPixelTransformer);
    }

    @Override
    public LazyArea createResult(PixelTransformer pTransformer, LazyArea pFirstArea, LazyArea pSecondArea) {
        return new LazyArea(this.cache, Math.min(1024, Math.max(pFirstArea.getMaxCache(), pSecondArea.getMaxCache()) * 4), pTransformer);
    }

    @Override
    public void initRandom(long pX, long pZ) {
        long i = this.seed;
        i = LinearCongruentialGenerator.next((long)i, (long)pX);
        i = LinearCongruentialGenerator.next((long)i, (long)pZ);
        i = LinearCongruentialGenerator.next((long)i, (long)pX);
        this.rval = i = LinearCongruentialGenerator.next((long)i, (long)pZ);
    }

    @Override
    public int nextRandom(int pBound) {
        int i = Math.floorMod(this.rval >> 24, pBound);
        this.rval = LinearCongruentialGenerator.next((long)this.rval, (long)this.seed);
        return i;
    }

    @Override
    public ImprovedNoise getBiomeNoise() {
        return this.biomeNoise;
    }

    private static long mixSeed(long pLeft, long pRight) {
        long i = LinearCongruentialGenerator.next((long)pRight, (long)pRight);
        i = LinearCongruentialGenerator.next((long)i, (long)pRight);
        i = LinearCongruentialGenerator.next((long)i, (long)pRight);
        long j = LinearCongruentialGenerator.next((long)pLeft, (long)i);
        j = LinearCongruentialGenerator.next((long)j, (long)i);
        return LinearCongruentialGenerator.next((long)j, (long)i);
    }
}

