/*
 * Decompiled with CFR 0.152.
 */
package com.convallyria.hugestructureblocks.mixin.structure;

import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.properties.StructureMode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(value={StructureBlockEntity.class}, priority=999)
public class StructureBlockUnlimit {
    @ModifyConstant(method={"loadAdditional(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V"}, constant={@Constant(intValue=48)}, require=0)
    public int readNbtUpper(int value) {
        return 512;
    }

    @ModifyConstant(method={"loadAdditional(Lnet/minecraft/nbt/CompoundTag;Lnet/minecraft/core/HolderLookup$Provider;)V"}, constant={@Constant(intValue=-48)}, require=0)
    public int readNbtLower(int value) {
        return -512;
    }

    @Overwrite
    private Stream<BlockPos> getRelatedCorners(BlockPos min, BlockPos max) {
        StructureBlockEntity blockEntity = (StructureBlockEntity)this;
        Level level = blockEntity.getLevel();
        if (level == null) {
            return Stream.empty();
        }
        BlockPos middle = blockEntity.getBlockPos();
        ArrayList blocks = new ArrayList(2);
        int maxSearch = this.detectSize(-1) + 1;
        BlockPos.findClosestMatch((BlockPos)middle, (int)maxSearch, (int)Math.min(maxSearch, level.getHeight() + 1), pos -> {
            StructureBlockEntity block;
            BlockEntity patt0$temp = level.getBlockEntity(pos);
            if (patt0$temp instanceof StructureBlockEntity && (block = (StructureBlockEntity)patt0$temp).getMode() == StructureMode.CORNER && Objects.equals(blockEntity.getStructureName(), block.getStructureName())) {
                blocks.add(block.getBlockPos());
            }
            return blocks.size() == 2;
        });
        return blocks.stream();
    }

    @ModifyConstant(method={"detectSize()Z"}, constant={@Constant(intValue=80)}, require=0)
    public int detectSize(int value) {
        return 512;
    }
}

