/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.client.render;

import com.nine.ironladders.common.block.BaseMetalLadder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.DelegateBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import org.jetbrains.annotations.NotNull;

public class MetalLadderBakedModel
extends DelegateBakedModel {
    public static final ModelProperty<BlockState> MORPH_MODEL_PROPERTY = new ModelProperty();

    public MetalLadderBakedModel(BakedModel bakedModel) {
        super(bakedModel);
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        if (data == null) {
            return super.getParticleIcon(ModelData.builder().build());
        }
        BlockState morphState = (BlockState)data.get(MORPH_MODEL_PROPERTY);
        if (morphState == null) {
            return super.getParticleIcon(data);
        }
        BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(morphState);
        return model.getParticleIcon(morphState.getBlock() instanceof BaseMetalLadder ? null : data);
    }

    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        BlockState morphState = data != null ? (BlockState)data.get(MORPH_MODEL_PROPERTY) : null;
        Minecraft mc = Minecraft.getInstance();
        ChunkRenderTypeSet typeSet = state.getBlock() instanceof BaseMetalLadder ? super.getRenderTypes(state, rand, ModelData.EMPTY) : (morphState != null ? mc.getBlockRenderer().getBlockModel(morphState).getRenderTypes(morphState, rand, data) : ItemBlockRenderTypes.getRenderLayers((BlockState)state));
        return ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{typeSet});
    }

    @NotNull
    public List<BakedQuad> getQuads(BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, RenderType renderType) {
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        BlockState morphState = (BlockState)extraData.get(MORPH_MODEL_PROPERTY);
        if (morphState != null) {
            morphState = morphState.getBlock().withPropertiesOf(state);
            BakedModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(morphState);
            if (morphState.getBlock() instanceof BaseMetalLadder) {
                result.addAll(model.getQuads(morphState, side, rand, ModelData.EMPTY, renderType));
            } else {
                result.addAll(model.getQuads(morphState, side, rand, extraData, renderType));
            }
            return result;
        }
        result.addAll(super.getQuads(state, side, rand, extraData, renderType));
        return result;
    }
}

