/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.common.item;

import com.nine.ironladders.ILConfig;
import com.nine.ironladders.client.ClientHelper;
import com.nine.ironladders.common.block.BaseMetalLadder;
import com.nine.ironladders.common.utils.LadderProperties;
import com.nine.ironladders.common.utils.LadderType;
import com.nine.ironladders.common.utils.UpgradeType;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;

public class UpgradeItem
extends Item {
    UpgradeType type;

    public UpgradeItem(Item.Properties properties, UpgradeType type) {
        super(properties);
        this.type = type;
    }

    public void inventoryTick(ItemStack stack, Level pLevel, Entity pEntity, int pItemSlot, boolean pIsSelected) {
        if (stack.getDamageValue() == stack.getMaxDamage() && !pLevel.isClientSide) {
            stack.shrink(1);
        }
    }

    /*
     * Unable to fully structure code
     */
    public InteractionResult useOn(UseOnContext context) {
        block9: {
            if (!((Boolean)ILConfig.enableTierLaddersUpgrade.get()).booleanValue()) {
                return InteractionResult.FAIL;
            }
            blockPos = context.getClickedPos();
            stack = context.getItemInHand();
            player = context.getPlayer();
            level = context.getLevel();
            blockState = level.getBlockState(blockPos);
            block = blockState.getBlock();
            upgradeItem = this;
            if (player == null || stack.getDamageValue() == stack.getMaxDamage() || !((Boolean)ILConfig.enableTierLaddersUpgrade.get()).booleanValue()) {
                return InteractionResult.FAIL;
            }
            if (stack.getDamageValue() == stack.getMaxDamage()) {
                this.remove(player, stack);
            }
            if (!(block instanceof LadderBlock)) break block9;
            upgradeState = this.type.getUpgradeType().getBlock(this.type.getUpgradeType()).withPropertiesOf(blockState);
            v0 = defaultLadder = block == Blocks.LADDER && this.type.getPreviousType() == LadderType.DEFAULT;
            if (!(block instanceof BaseMetalLadder)) ** GOTO lbl-1000
            metalLadder = (BaseMetalLadder)block;
            if (this.type.getPreviousType() == metalLadder.getType()) {
                v1 = true;
            } else lbl-1000:
            // 2 sources

            {
                v1 = upgradeableLadder = false;
            }
            if (!player.isShiftKeyDown()) {
                if (defaultLadder || upgradeableLadder) {
                    UpgradeItem.upgradeSingleBlock(level, player, blockPos, upgradeState, stack);
                    return InteractionResult.SUCCESS;
                }
            } else if (defaultLadder || upgradeableLadder) {
                UpgradeItem.upgradeSingleBlock(level, player, blockPos, upgradeState, stack);
                this.upgradeMultipleLadders(player, level, blockPos, blockState, upgradeState, upgradeItem, stack);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    private static void upgradeSingleBlock(Level level, Player player, BlockPos blockPos, BlockState upgradeState, ItemStack stack) {
        level.removeBlock(blockPos, false);
        level.setBlock(blockPos, upgradeState, 3);
        ClientHelper.spawnUpgradeParticles(blockPos, upgradeState, level);
        level.playSound(null, blockPos, SoundEvents.LADDER_PLACE, SoundSource.BLOCKS, 1.0f, 0.9f + level.random.nextFloat() * 0.2f);
        if (!player.getAbilities().instabuild) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
        }
    }

    public void upgradeMultipleLadders(Player player, Level level, BlockPos blockPos, BlockState oldState, BlockState newState, UpgradeItem upgradeItem, ItemStack stack) {
        int ladderCount = 0;
        int height = 1;
        boolean canGoUp = true;
        boolean canGoDown = true;
        while (ladderCount < 128) {
            BaseMetalLadder metalLadder;
            LadderType startType;
            Block startBlock = oldState.getBlock();
            LadderType upperType = startType = LadderType.DEFAULT;
            LadderType bottomType = startType;
            Direction startFacingDirection = (Direction)oldState.getValue(LadderProperties.FACING);
            if (startBlock instanceof BaseMetalLadder) {
                BaseMetalLadder metalLadder2 = (BaseMetalLadder)startBlock;
                startType = metalLadder2.getType();
            }
            BlockState stateAbove = level.getBlockState(blockPos.above(height));
            BlockPos abovePos = blockPos.above(height);
            Block blockAbove = stateAbove.getBlock();
            BlockPos belowPos = blockPos.below(height);
            BlockState stateBelow = level.getBlockState(blockPos.below(height));
            Block blockBelow = stateBelow.getBlock();
            if (blockAbove instanceof BaseMetalLadder) {
                metalLadder = (BaseMetalLadder)blockAbove;
                upperType = metalLadder.getType();
            }
            if (blockBelow instanceof BaseMetalLadder) {
                metalLadder = (BaseMetalLadder)blockBelow;
                bottomType = metalLadder.getType();
            }
            if (canGoUp) {
                Direction currentUpFacingDirection;
                canGoUp = blockAbove instanceof LadderBlock ? startFacingDirection == (currentUpFacingDirection = (Direction)stateAbove.getValue(LadderProperties.FACING)) : false;
            }
            if (canGoDown) {
                Direction currentDownFacingDirection;
                canGoDown = blockBelow instanceof LadderBlock ? startFacingDirection == (currentDownFacingDirection = (Direction)stateBelow.getValue(LadderProperties.FACING)) : false;
            }
            if (!canGoUp && !canGoDown || stack.getDamageValue() >= stack.getMaxDamage()) break;
            if (canGoUp && upperType == startType) {
                newState = newState.getBlock().withPropertiesOf(stateAbove);
                UpgradeItem.upgradeSingleBlock(level, player, abovePos, newState, stack);
                ++ladderCount;
            }
            if (canGoDown && ladderCount != stack.getMaxDamage() && bottomType == startType) {
                newState = newState.getBlock().withPropertiesOf(stateBelow);
                UpgradeItem.upgradeSingleBlock(level, player, belowPos, newState, stack);
                ++ladderCount;
            }
            ++height;
        }
        if (stack.getDamageValue() == stack.getMaxDamage()) {
            upgradeItem.remove(player, stack);
        }
    }

    public UpgradeType getType() {
        return this.type;
    }

    private void remove(Player player, ItemStack stack) {
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext pContext, List<Component> tooltip, TooltipFlag pTooltipFlag) {
        if (!((Boolean)ILConfig.enableTierLaddersUpgrade.get()).booleanValue()) {
            tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.disabled").withStyle(ChatFormatting.RED));
            return;
        }
        boolean shiftDown = Screen.hasShiftDown();
        Component component1 = ClientHelper.componentWithColor((Component)Component.translatable((String)"ironladders.tooltip.shift"), shiftDown ? 0xCBCBCB : 0x808080);
        MutableComponent component2 = Component.translatable((String)"ironladders.tooltip.hold_for", (Object[])new Object[]{component1}).withStyle(ChatFormatting.GRAY);
        tooltip.add((Component)component2);
        if (shiftDown) {
            Component component3 = ClientHelper.componentWithColor((Component)Component.translatable((String)"ironladders.tooltip.upgrade_item.info_2"), 0xCBCBCB);
            Component amount = ClientHelper.componentWithColor((Component)Component.literal((String)String.valueOf(stack.getMaxDamage() - stack.getDamageValue())), 0xCBCBCB);
            tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.upgrade_item.info_0", (Object[])new Object[]{amount}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)Component.translatable((String)"ironladders.tooltip.upgrade_item.info_1", (Object[])new Object[]{component3}).withStyle(ChatFormatting.GRAY));
        }
    }
}

