/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.common.utils;

import com.nine.ironladders.ILConfig;
import com.nine.ironladders.init.BlockRegistry;
import com.nine.ironladders.init.ItemRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class TagHelper {
    public static final TagKey<Item> steel = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/steel"));
    public static final TagKey<Item> lead = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/lead"));
    public static final TagKey<Item> tin = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/tin"));
    public static final TagKey<Item> bronze = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/bronze"));
    public static final TagKey<Item> silver = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/silver"));
    public static final TagKey<Item> aluminum = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/aluminum"));
    public static final List<TagKey<Item>> availableTags = new ArrayList<TagKey<Item>>();
    public static List<TagKey<Item>> tagsToCheck = List.of(steel, lead, tin, bronze, silver, aluminum);

    private static void initializeAvailableTags() {
        for (Item item : BuiltInRegistries.ITEM) {
            for (TagKey<Item> tag : tagsToCheck) {
                if (!item.builtInRegistryHolder().is(tag)) continue;
                availableTags.add(tag);
            }
        }
    }

    public static List<Item> getItemsToHide() {
        ArrayList<Item> items = new ArrayList<Item>();
        if (!TagHelper.hasMaterial(tin)) {
            items.add((Item)ItemRegistry.WOOD_TIN_UPGRADE.get());
            items.add(((Block)BlockRegistry.TIN_LADDER.get()).asItem());
        }
        if (!TagHelper.hasMaterial(bronze)) {
            items.add((Item)ItemRegistry.WOOD_BRONZE_UPGRADE.get());
            items.add(((Block)BlockRegistry.BRONZE_LADDER.get()).asItem());
        }
        if (!TagHelper.hasMaterial(lead)) {
            items.add((Item)ItemRegistry.WOOD_LEAD_UPGRADE.get());
            items.add(((Block)BlockRegistry.LEAD_LADDER.get()).asItem());
        }
        if (!TagHelper.hasMaterial(steel)) {
            items.add((Item)ItemRegistry.WOOD_STEEL_UPGRADE.get());
            items.add(((Block)BlockRegistry.STEEL_LADDER.get()).asItem());
        }
        if (!TagHelper.hasMaterial(aluminum)) {
            items.add((Item)ItemRegistry.WOOD_ALUMINUM_UPGRADE.get());
            items.add(((Block)BlockRegistry.ALUMINUM_LADDER.get()).asItem());
        }
        if (!TagHelper.hasMaterial(silver)) {
            items.add((Item)ItemRegistry.WOOD_SILVER_UPGRADE.get());
            items.add(((Block)BlockRegistry.SILVER_LADDER.get()).asItem());
        }
        items.add(((Block)BlockRegistry.CRYING_OBSIDIAN_LADDER.get()).asItem());
        items.add(((Block)BlockRegistry.BEDROCK_LADDER.get()).asItem());
        return items;
    }

    public static boolean hasMaterial(TagKey<Item> tag) {
        if (!((Boolean)ILConfig.hideUncraftableLadders.get()).booleanValue()) {
            return true;
        }
        if (availableTags.isEmpty()) {
            TagHelper.initializeAvailableTags();
        }
        return availableTags.contains(tag);
    }
}

