/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.datagen;

import com.nine.ironladders.common.utils.LadderTags;
import com.nine.ironladders.init.BlockRegistry;
import com.nine.ironladders.init.ItemRegistry;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.packs.VanillaRecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ILRecipeProvider
extends RecipeProvider {
    public ILRecipeProvider(HolderLookup.Provider provider, RecipeOutput output) {
        super(provider, output);
    }

    protected void buildRecipes() {
        TagKey copper = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/copper"));
        TagKey iron = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/iron"));
        TagKey gold = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/gold"));
        TagKey diamond = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:gems/diamond"));
        TagKey netherite = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/netherite"));
        TagKey redstone = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:dusts/redstone"));
        TagKey slime = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:slime_balls"));
        TagKey glass = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:glass_blocks/cheap"));
        TagKey whiteDye = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:dyes/white"));
        TagKey glowstoneDust = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:dusts/glowstone"));
        TagKey obsidian = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:obsidians"));
        TagKey steel = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/steel"));
        TagKey lead = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/lead"));
        TagKey tin = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/tin"));
        TagKey bronze = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/bronze"));
        TagKey silver = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/silver"));
        TagKey aluminum = ItemTags.create((ResourceLocation)ResourceLocation.parse((String)"c:ingots/aluminum"));
        TagKey<Item> upgradesToIronUpgrade = LadderTags.UPGRADES_TO_IRON_UPGRADE;
        TagKey<Item> upgradesToGoldUpgrade = LadderTags.UPGRADES_TO_GOLD_UPGRADE;
        TagKey<Item> upgradesToDiamondUpgrade = LadderTags.UPGRADES_TO_DIAMOND_UPGRADE;
        TagKey<Item> upgradesToObsidianUpgrade = LadderTags.UPGRADES_TO_OBSIDIAN_UPGRADE;
        TagKey<Item> upgradesToNetheriteUpgrade = LadderTags.UPGRADES_TO_NETHERITE_UPGRADE;
        TagKey<Item> upgradesToIron = LadderTags.UPGRADES_TO_IRON;
        TagKey<Item> upgradesToGold = LadderTags.UPGRADES_TO_GOLD;
        TagKey<Item> upgradesToDiamond = LadderTags.UPGRADES_TO_DIAMOND;
        TagKey<Item> upgradesToObsidian = LadderTags.UPGRADES_TO_OBSIDIAN;
        TagKey<Item> upgradesToNetherite = LadderTags.UPGRADES_TO_NETHERITE;
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)BlockRegistry.IRON_LADDER.get(), 7).define(Character.valueOf('I'), iron).define(Character.valueOf('L'), (ItemLike)Items.LADDER).pattern("LIL").pattern("LIL").pattern("LIL").unlockedBy("has_ingot", this.has(iron)).save(this.output, this.getRecipeId("ironladders", "iron_ladder_from_regular_one"));
        this.ladder((TagKey<Item>)copper, (ItemLike)BlockRegistry.COPPER_LADDER.get(), (ItemLike)Items.LADDER);
        this.ladder((TagKey<Item>)iron, (ItemLike)BlockRegistry.IRON_LADDER.get(), upgradesToIron);
        this.ladder((TagKey<Item>)gold, (ItemLike)BlockRegistry.GOLD_LADDER.get(), upgradesToGold);
        this.ladder((TagKey<Item>)diamond, (ItemLike)BlockRegistry.DIAMOND_LADDER.get(), upgradesToDiamond);
        this.ladder(Blocks.OBSIDIAN.asItem(), (ItemLike)BlockRegistry.OBSIDIAN_LADDER.get(), upgradesToObsidian);
        this.ladder((TagKey<Item>)netherite, (ItemLike)BlockRegistry.NETHERITE_LADDER.get(), upgradesToNetherite);
        this.shapeless(RecipeCategory.DECORATIONS, (ItemLike)BlockRegistry.WAXED_COPPER_LADDER.get()).requires((ItemLike)BlockRegistry.COPPER_LADDER.get()).requires((ItemLike)Items.HONEYCOMB).group("ladders_waxing").unlockedBy("has_ladder", this.has((ItemLike)BlockRegistry.COPPER_LADDER.get())).save(this.output, this.getRecipeId("ironladders", ILRecipeProvider.getItemName((ItemLike)((ItemLike)BlockRegistry.WAXED_COPPER_LADDER.get())) + "_from_" + ILRecipeProvider.getItemName((ItemLike)((ItemLike)BlockRegistry.COPPER_LADDER.get()))));
        this.shapeless(RecipeCategory.DECORATIONS, (ItemLike)BlockRegistry.WAXED_EXPOSED_COPPER_LADDER.get()).requires((ItemLike)BlockRegistry.EXPOSED_COPPER_LADDER.get()).requires((ItemLike)Items.HONEYCOMB).group("ladders_waxing").unlockedBy("has_ladder", this.has((ItemLike)BlockRegistry.EXPOSED_COPPER_LADDER.get())).save(this.output, this.getRecipeId("ironladders", ILRecipeProvider.getItemName((ItemLike)((ItemLike)BlockRegistry.WAXED_EXPOSED_COPPER_LADDER.get())) + "_from_" + ILRecipeProvider.getItemName((ItemLike)((ItemLike)BlockRegistry.EXPOSED_COPPER_LADDER.get()))));
        this.shapeless(RecipeCategory.DECORATIONS, (ItemLike)BlockRegistry.WAXED_WEATHERED_COPPER_LADDER.get()).requires((ItemLike)BlockRegistry.WEATHERED_COPPER_LADDER.get()).requires((ItemLike)Items.HONEYCOMB).group("ladders_waxing").unlockedBy("has_ladder", this.has((ItemLike)BlockRegistry.WEATHERED_COPPER_LADDER.get())).save(this.output, this.getRecipeId("ironladders", ILRecipeProvider.getItemName((ItemLike)((ItemLike)BlockRegistry.WAXED_WEATHERED_COPPER_LADDER.get())) + "_from_" + ILRecipeProvider.getItemName((ItemLike)((ItemLike)BlockRegistry.WEATHERED_COPPER_LADDER.get()))));
        this.shapeless(RecipeCategory.DECORATIONS, (ItemLike)BlockRegistry.WAXED_OXIDIZED_COPPER_LADDER.get()).requires((ItemLike)BlockRegistry.OXIDIZED_COPPER_LADDER.get()).requires((ItemLike)Items.HONEYCOMB).group("ladders_waxing").unlockedBy("has_ladder", this.has((ItemLike)BlockRegistry.OXIDIZED_COPPER_LADDER.get())).save(this.output, this.getRecipeId("ironladders", ILRecipeProvider.getItemName((ItemLike)((ItemLike)BlockRegistry.WAXED_OXIDIZED_COPPER_LADDER.get())) + "_from_" + ILRecipeProvider.getItemName((ItemLike)((ItemLike)BlockRegistry.OXIDIZED_COPPER_LADDER.get()))));
        this.shaped(RecipeCategory.MISC, (ItemLike)ItemRegistry.WOOD_IRON_UPGRADE.get(), 1).define(Character.valueOf('I'), iron).define(Character.valueOf('L'), (ItemLike)Items.LADDER).pattern("III").pattern(" II").pattern("L I").unlockedBy("has_ingot", this.has(iron)).save(this.output, this.getRecipeId("ironladders", "iron_upgrade_from_ladder"));
        this.shaped(RecipeCategory.MISC, (ItemLike)ItemRegistry.POWER_UPGRADE_ITEM.get(), 1).define(Character.valueOf('R'), redstone).define(Character.valueOf('L'), (ItemLike)Items.LADDER).define(Character.valueOf('P'), (ItemLike)Items.PISTON).define(Character.valueOf('D'), (ItemLike)Items.REPEATER).define(Character.valueOf('T'), (ItemLike)Items.REDSTONE_TORCH).pattern(" DT").pattern(" RP").pattern("L  ").unlockedBy("has_redstone", this.has(redstone)).unlockedBy("has_repeater", this.has((ItemLike)Items.REPEATER)).unlockedBy("has_piston", this.has((ItemLike)Items.PISTON)).unlockedBy("has_redstone_torch", this.has((ItemLike)Items.REDSTONE_TORCH)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)ItemRegistry.MORPH_UPGRADE_ITEM.get(), 1).define(Character.valueOf('S'), slime).define(Character.valueOf('L'), (ItemLike)Items.LADDER).define(Character.valueOf('P'), (ItemLike)Items.PAPER).pattern(" SP").pattern(" SS").pattern("L  ").unlockedBy("has_slime", this.has(slime)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)ItemRegistry.HIDE_UPGRADE_ITEM.get(), 1).define(Character.valueOf('G'), glass).define(Character.valueOf('L'), (ItemLike)Items.LADDER).define(Character.valueOf('D'), whiteDye).pattern(" GD").pattern(" GG").pattern("L  ").unlockedBy("has_dye", this.has(whiteDye)).save(this.output);
        this.shaped(RecipeCategory.MISC, (ItemLike)ItemRegistry.LIGHT_UPGRADE_ITEM.get(), 1).define(Character.valueOf('D'), glowstoneDust).define(Character.valueOf('L'), (ItemLike)Items.LADDER).define(Character.valueOf('B'), (ItemLike)Items.GLOWSTONE).pattern(" DB").pattern(" DD").pattern("L  ").unlockedBy("has_glowstone", this.has(glowstoneDust)).save(this.output);
        this.ladderWoodUpgrade((TagKey<Item>)iron, (ItemLike)ItemRegistry.WOOD_IRON_UPGRADE.get(), upgradesToIronUpgrade);
        this.ladderWoodUpgrade((TagKey<Item>)gold, (ItemLike)ItemRegistry.WOOD_GOLD_UPGRADE.get(), upgradesToGoldUpgrade);
        this.ladderWoodUpgrade((TagKey<Item>)diamond, (ItemLike)ItemRegistry.WOOD_DIAMOND_UPGRADE.get(), upgradesToDiamondUpgrade);
        this.ladderWoodUpgrade((TagKey<Item>)obsidian, (ItemLike)ItemRegistry.WOOD_OBSIDIAN_UPGRADE.get(), upgradesToObsidianUpgrade);
        this.ladderWoodUpgrade((TagKey<Item>)netherite, (ItemLike)ItemRegistry.WOOD_NETHERITE_UPGRADE.get(), upgradesToNetheriteUpgrade);
        this.ladderUpgrade((TagKey<Item>)copper, (ItemLike)ItemRegistry.COPPER_UPGRADE.get());
        this.ladderUpgrade((TagKey<Item>)iron, (ItemLike)ItemRegistry.IRON_UPGRADE.get());
        this.ladderUpgrade((TagKey<Item>)gold, (ItemLike)ItemRegistry.GOLD_UPGRADE.get());
        this.ladderUpgrade((TagKey<Item>)diamond, (ItemLike)ItemRegistry.DIAMOND_UPGRADE.get());
        this.ladderUpgrade((TagKey<Item>)obsidian, (ItemLike)ItemRegistry.OBSIDIAN_UPGRADE.get());
        this.ladderUpgrade((TagKey<Item>)netherite, (ItemLike)ItemRegistry.NETHERITE_UPGRADE.get());
        this.shaped(RecipeCategory.DECORATIONS, (ItemLike)BlockRegistry.CRYING_OBSIDIAN_LADDER.get(), 9).define(Character.valueOf('I'), (ItemLike)Blocks.CRYING_OBSIDIAN).define(Character.valueOf('L'), (ItemLike)BlockRegistry.OBSIDIAN_LADDER.get()).pattern("LIL").pattern("LLL").pattern("LIL").unlockedBy("has_ladder", this.has(LadderTags.UNKNOWN)).save(this.output, this.getRecipeId("ironladders", "secret_ladder_recipe"));
        this.ladderUpgrade((TagKey<Item>)lead, (ItemLike)ItemRegistry.WOOD_LEAD_UPGRADE.get());
        this.ladderWoodUpgrade((TagKey<Item>)steel, (ItemLike)ItemRegistry.WOOD_STEEL_UPGRADE.get(), upgradesToIronUpgrade);
        this.ladderWoodUpgrade((TagKey<Item>)bronze, (ItemLike)ItemRegistry.WOOD_BRONZE_UPGRADE.get(), upgradesToIronUpgrade);
        this.ladderUpgrade((TagKey<Item>)tin, (ItemLike)ItemRegistry.WOOD_TIN_UPGRADE.get());
        this.ladderWoodUpgrade((TagKey<Item>)silver, (ItemLike)ItemRegistry.WOOD_SILVER_UPGRADE.get(), upgradesToGoldUpgrade);
        this.ladderUpgrade((TagKey<Item>)aluminum, (ItemLike)ItemRegistry.WOOD_ALUMINUM_UPGRADE.get());
        this.ladder((TagKey<Item>)steel, (ItemLike)BlockRegistry.STEEL_LADDER.get(), upgradesToIron);
        this.ladder((TagKey<Item>)lead, (ItemLike)BlockRegistry.LEAD_LADDER.get(), (ItemLike)Items.LADDER);
        this.ladder((TagKey<Item>)tin, (ItemLike)BlockRegistry.TIN_LADDER.get(), (ItemLike)Items.LADDER);
        this.ladder((TagKey<Item>)silver, (ItemLike)BlockRegistry.SILVER_LADDER.get(), upgradesToGold);
        this.ladder((TagKey<Item>)bronze, (ItemLike)BlockRegistry.BRONZE_LADDER.get(), upgradesToIron);
        this.ladder((TagKey<Item>)aluminum, (ItemLike)BlockRegistry.ALUMINUM_LADDER.get(), (ItemLike)Items.LADDER);
    }

    private void ladder(TagKey<Item> material, ItemLike result, ItemLike ladderBefore) {
        this.shaped(RecipeCategory.DECORATIONS, result, 7).define(Character.valueOf('I'), material).define(Character.valueOf('L'), ladderBefore).pattern("LIL").pattern("LLL").pattern("LIL").unlockedBy("has_material", this.has(material)).unlockedBy("has_ladder", this.has(ladderBefore)).save(this.output);
    }

    private void ladder(TagKey<Item> material, ItemLike result, TagKey<Item> ladderBefore) {
        this.shaped(RecipeCategory.DECORATIONS, result, 7).define(Character.valueOf('I'), material).define(Character.valueOf('L'), ladderBefore).pattern("LIL").pattern("LLL").pattern("LIL").unlockedBy("has_material", this.has(material)).unlockedBy("has_ladder", this.has(ladderBefore)).save(this.output);
    }

    private void ladder(Item material, ItemLike result, TagKey<Item> ladderBefore) {
        this.shaped(RecipeCategory.DECORATIONS, result, 7).define(Character.valueOf('I'), (ItemLike)material).define(Character.valueOf('L'), ladderBefore).pattern("LIL").pattern("LLL").pattern("LIL").unlockedBy("has_material", this.has((ItemLike)material)).unlockedBy("has_ladder", this.has(ladderBefore)).save(this.output);
    }

    private void ladder(Item material, ItemLike result, Item ladderBefore) {
        this.shaped(RecipeCategory.DECORATIONS, result, 7).define(Character.valueOf('I'), (ItemLike)material).define(Character.valueOf('L'), (ItemLike)ladderBefore).pattern("LIL").pattern("LLL").pattern("LIL").unlockedBy("has_material", this.has((ItemLike)material)).unlockedBy("has_ladder", this.has((ItemLike)ladderBefore)).save(this.output);
    }

    private void ladderUpgrade(TagKey<Item> material, ItemLike result) {
        this.shaped(RecipeCategory.MISC, result, 1).define(Character.valueOf('I'), material).define(Character.valueOf('R'), (ItemLike)Blocks.LADDER).pattern(" II").pattern(" II").pattern("R  ").unlockedBy("has_material", this.has(material)).save(this.output);
    }

    private void ladderWoodUpgrade(TagKey<Item> material, ItemLike result, TagKey<Item> upgradeBefore) {
        this.shaped(RecipeCategory.MISC, result, 1).define(Character.valueOf('I'), material).define(Character.valueOf('L'), upgradeBefore).pattern(" II").pattern(" II").pattern("L  ").unlockedBy("has_material", this.has(material)).save(this.output, this.getRecipeId("ironladders", "wood_" + VanillaRecipeProvider.getItemName((ItemLike)result)));
    }

    private String getRecipeId(String modid, String item) {
        return modid + ":" + item;
    }

    public static final class Runner
    extends RecipeProvider.Runner {
        public Runner(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider) {
            super(output, lookupProvider);
        }

        protected RecipeProvider createRecipeProvider(HolderLookup.Provider provider, RecipeOutput recipeOutput) {
            return new ILRecipeProvider(this, provider, recipeOutput){};
        }

        public String getName() {
            return "Iron Ladders Recipes";
        }
    }
}

