/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.mixin;

import com.nine.ironladders.ILConfig;
import com.nine.ironladders.client.ClientHelper;
import com.nine.ironladders.common.block.BaseMetalLadder;
import com.nine.ironladders.common.utils.PlayerInputDataProvider;
import com.nine.ironladders.network.SyncPlayerInputData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Shadow
    protected boolean jumping;

    @Inject(method={"handleOnClimbable"}, at={@At(value="TAIL")})
    protected void ironladders$handleOnClimbable(Vec3 vec3, CallbackInfoReturnable ci) {
        boolean shouldWork;
        LivingEntity livingEntity = (LivingEntity)this;
        boolean bl = shouldWork = !((List)ILConfig.entitiesPoweredLadderBlackList.get()).contains(livingEntity.getType().toString());
        if (!(livingEntity instanceof Player) && ((Boolean)ILConfig.enableIronLaddersSpeedMultiplierForPlayersOnly.get()).booleanValue()) {
            shouldWork = false;
        }
        if (livingEntity.onClimbable() && shouldWork && ((Boolean)ILConfig.enableIronLaddersSpeedMultiplier.get()).booleanValue()) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                if (player.getAbilities().flying) {
                    return;
                }
            }
            livingEntity.resetFallDistance();
            BlockState state = livingEntity.level().getBlockState(new BlockPos(livingEntity.getBlockX(), livingEntity.getBlockY(), livingEntity.getBlockZ()));
            Block block = state.getBlock();
            float m = Math.abs(livingEntity.getXRot() / 80.0f);
            if (block instanceof BaseMetalLadder) {
                double yOffset;
                BaseMetalLadder metalLadder = (BaseMetalLadder)block;
                if (LivingEntityMixin.checkPlayerDirection(state, livingEntity)) {
                    m = 1.0f;
                }
                double speedMultiplier = (double)metalLadder.getSpeedMultiplier() / 100.0;
                if (livingEntity instanceof Player) {
                    boolean playerGoForward;
                    Player player = (Player)livingEntity;
                    if (player.level().isClientSide) {
                        playerGoForward = ClientHelper.checkGoForward(player);
                        PacketDistributor.sendToServer((CustomPacketPayload)new SyncPlayerInputData(playerGoForward), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    } else {
                        playerGoForward = ((PlayerInputDataProvider)player).forwardImpulse();
                    }
                    double d = speedMultiplier = playerGoForward && (double)m < 0.3 ? 0.0 : speedMultiplier;
                }
                if (metalLadder.isPowered(state) && (livingEntity instanceof Player || !((Boolean)ILConfig.enablePoweredLaddersSpeedMultiplierForPlayersOnly.get()).booleanValue())) {
                    if (metalLadder.isPoweredAndHasSignal(state) || livingEntity.horizontalCollision || this.jumping) {
                        double b = livingEntity.horizontalCollision || this.jumping ? 0.0 : 0.2;
                        yOffset = speedMultiplier + b;
                    } else {
                        yOffset = livingEntity.horizontalCollision || this.jumping ? -speedMultiplier : -speedMultiplier * (double)m * 0.5;
                    }
                } else {
                    double d = yOffset = livingEntity.horizontalCollision || this.jumping ? speedMultiplier : -speedMultiplier * (double)m * 0.5;
                }
                if (!livingEntity.isCrouching()) {
                    livingEntity.move(MoverType.SELF, new Vec3(0.0, yOffset, 0.0));
                }
            }
        }
    }

    @Unique
    private static boolean checkPlayerDirection(BlockState state, LivingEntity player) {
        Direction blockDirection = (Direction)state.getValue((Property)LadderBlock.FACING);
        Direction playerDirection = player.getDirection().getOpposite();
        return playerDirection == blockDirection || playerDirection == blockDirection.getClockWise() || playerDirection == blockDirection.getCounterClockWise();
    }
}

