/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.mixin.client;

import com.nine.ironladders.client.ClientHelper;
import com.nine.ironladders.common.item.MorphUpgradeItem;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LadderBlock;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class})
public class AbstractContainerMenuMixin {
    @Inject(method={"doClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void ironladders$doClick(int slotId, int button, ClickType clickType, Player player, CallbackInfo ci) {
        AbstractContainerMenu containerMenu = (AbstractContainerMenu)this;
        if (ClientHelper.shiftPressed()) {
            if (slotId < 0) {
                return;
            }
            ItemStack heldItem = player.containerMenu.getCarried();
            Slot slot4 = (Slot)containerMenu.slots.get(slotId);
            ItemStack itemStack7 = slot4.getItem();
            Item item = itemStack7.getItem();
            if (item instanceof BlockItem) {
                BlockItem ladderBlock = (BlockItem)item;
                item = heldItem.getItem();
                if (item instanceof MorphUpgradeItem) {
                    MorphUpgradeItem morphUpgradeItem = (MorphUpgradeItem)item;
                    Block block = ladderBlock.getBlock();
                    if (block instanceof LadderBlock) {
                        LadderBlock ladder = (LadderBlock)block;
                        MorphUpgradeItem.writeMorphType(heldItem, Objects.requireNonNull(BuiltInRegistries.BLOCK.getKey((Object)ladder)).toString());
                        if (!player.isSilent()) {
                            player.playSound(SoundEvents.SLIME_SQUISH, 0.5f, 1.0f);
                        }
                        ci.cancel();
                    }
                }
            }
        }
    }
}

