/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.mixin.client;

import com.nine.ironladders.IronLadders;
import com.nine.ironladders.common.item.MorphUpgradeItem;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemModelResolver.class})
public abstract class ItemModelResolverMixin {
    @Shadow
    @Final
    private Function<ResourceLocation, ItemModel> modelGetter;
    @Unique
    private ResourceManager resourceManager;
    @Unique
    private Map<String, String> morphModels;

    @Unique
    private void initializeResourceManager() {
        this.resourceManager = Minecraft.getInstance().getResourceManager();
    }

    @Inject(method={"appendItemLayers"}, at={@At(value="HEAD")}, cancellable=true)
    public void appendItemLayers(ItemStackRenderState renderState, ItemStack stack, ItemDisplayContext displayContext, Level level, LivingEntity entity, int seed, CallbackInfo ci) {
        Item item = stack.getItem();
        if (item instanceof MorphUpgradeItem) {
            MorphUpgradeItem morphUpgradeItem = (MorphUpgradeItem)item;
            if (!MorphUpgradeItem.getMorphType(stack).isEmpty()) {
                if (this.resourceManager == null || this.resourceManager.listPacks().toList().isEmpty()) {
                    this.initializeResourceManager();
                }
                if (this.morphModels == null || this.morphModels.isEmpty()) {
                    this.morphModels = new HashMap<String, String>();
                    String modelsPath = "items/morph_ladders";
                    Predicate<ResourceLocation> filter = resourceLocation -> resourceLocation.getPath().endsWith(".json");
                    for (ResourceLocation v : this.resourceManager.listResources(modelsPath, filter).keySet()) {
                        String location = v.toString();
                        try {
                            String d = location.split("\\.")[0].split("/")[2].split("_", 2)[1];
                            String f = location.split(":")[0] + ":morph_ladders/" + location.split("\\.")[0].split("/")[2];
                            this.morphModels.put(d, f);
                        }
                        catch (Exception ignored) {
                            IronLadders.LOGGER.warn("Failed to load morph model: " + location);
                        }
                    }
                }
                ItemModelResolver resolver = (ItemModelResolver)this;
                String morphType = MorphUpgradeItem.getMorphType(stack).split(":")[1];
                if (this.morphModels.containsKey(morphType)) {
                    ResourceLocation resourcelocation = ResourceLocation.parse((String)this.morphModels.get(morphType));
                    if (resourcelocation != null) {
                        ClientLevel clientlevel;
                        this.modelGetter.apply(resourcelocation).update(renderState, stack, resolver, displayContext, level instanceof ClientLevel ? (clientlevel = (ClientLevel)level) : null, entity, seed);
                    }
                    ci.cancel();
                }
            }
        }
    }
}

