/*
 * Decompiled with CFR 0.152.
 */
package com.nine.ironladders.mixin.client;

import com.nine.ironladders.common.block.BaseMetalLadder;
import com.nine.ironladders.common.item.MorphUpgradeItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class MultiPlayerGameModeMixin {
    @Inject(method={"destroyBlock"}, at={@At(value="HEAD")}, cancellable=true)
    public void destroyBlock(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.isShiftKeyDown() && player.getMainHandItem().getItem() instanceof MorphUpgradeItem && player.level().getBlockState(pos).getBlock() instanceof BaseMetalLadder) {
            if (!player.getCooldowns().isOnCooldown(player.getMainHandItem())) {
                this.multipleMorph((Player)player, pos);
            }
            cir.setReturnValue((Object)false);
        }
    }

    @Unique
    private void multipleMorph(Player player, BlockPos loc) {
        ItemStack stack;
        Item item;
        if (player != null && player.isShiftKeyDown() && (item = (stack = player.getMainHandItem()).getItem()) instanceof MorphUpgradeItem) {
            MorphUpgradeItem morphUpgradeItem = (MorphUpgradeItem)item;
            if (!player.getCooldowns().isOnCooldown(stack)) {
                morphUpgradeItem.morphMultipleLadders(player, stack, (Level)Minecraft.getInstance().level, loc);
            }
        }
    }
}

