/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.config;

import cc.cassian.item_descriptions.client.config.ModConfig;
import cc.cassian.item_descriptions.client.helpers.ModHelpers;
import java.lang.reflect.Field;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ClothConfigFactory {
    private static final ModConfig DEFAULT_VALUES = new ModConfig();

    public static Screen create(Screen parent) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setTitle((Component)Component.translatable((String)"config.item-descriptions.title"));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        ModConfig configInstance = ModConfig.get();
        ConfigCategory generalCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"config.item-descriptions.title"));
        ConfigCategory styleCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"config.item-descriptions.style_title"));
        ConfigCategory keyBindsCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"config.item-descriptions.keybinds_title"));
        ConfigCategory pluginsCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"config.item-descriptions.plugins_title"));
        ConfigCategory developerCategory = builder.getOrCreateCategory((Component)Component.translatable((String)"config.item-descriptions.developer_options_title"));
        for (Field field : ModConfig.class.getFields()) {
            ConfigCategory category = field.getName().contains("keybind") ? keyBindsCategory : (field.getName().toLowerCase().contains("block") ? pluginsCategory : (field.getName().toLowerCase().contains("entity") ? pluginsCategory : (field.getName().toLowerCase().contains("compat_") ? pluginsCategory : (field.getName().toLowerCase().contains("developer") ? developerCategory : (field.getName().toLowerCase().contains("style") ? styleCategory : generalCategory)))));
            if (field.getType() == Boolean.TYPE) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startBooleanToggle(ModHelpers.fieldName(field), ((Boolean)ModHelpers.fieldGet(configInstance, field)).booleanValue()).setSaveConsumer(ModHelpers.fieldSetter(configInstance, field)).setTooltip(ModHelpers.fieldTooltip(field)).setDefaultValue(((Boolean)ModHelpers.fieldGet(DEFAULT_VALUES, field)).booleanValue()).build());
                continue;
            }
            if (field.getType() == String.class) {
                category.addEntry((AbstractConfigListEntry)entryBuilder.startStrField(ModHelpers.fieldName(field), (String)ModHelpers.fieldGet(configInstance, field)).setSaveConsumer(ModHelpers.fieldSetter(configInstance, field)).setTooltip(ModHelpers.fieldTooltip(field)).setDefaultValue((String)ModHelpers.fieldGet(DEFAULT_VALUES, field)).build());
                continue;
            }
            if (field.getType() != Integer.TYPE) continue;
            category.addEntry((AbstractConfigListEntry)entryBuilder.startIntField(ModHelpers.fieldName(field), ((Integer)ModHelpers.fieldGet(configInstance, field)).intValue()).setSaveConsumer(ModHelpers.fieldSetter(configInstance, field)).setTooltip(ModHelpers.fieldTooltip(field)).setDefaultValue(((Integer)ModHelpers.fieldGet(DEFAULT_VALUES, field)).intValue()).build());
        }
        builder.setSavingRunnable(ModConfig::save);
        return builder.build();
    }
}

