/*
 * Decompiled with CFR 0.152.
 */
package cc.cassian.item_descriptions.client.config;

import cc.cassian.item_descriptions.client.ModClient;
import cc.cassian.item_descriptions.client.config.neoforge.ModConfigImpl;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ModConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static ModConfig INSTANCE = new ModConfig();
    public boolean itemDescriptions = true;
    public boolean displayAlways = false;
    public String style_color = "Gray";
    public boolean style_italics = false;
    public boolean style_bold = false;
    public int style_length = 40;
    public boolean keybind_displayWhenControlIsHeld = true;
    public boolean keybind_displayWhenShiftIsHeld = false;
    public boolean keybind_displayWhenAltIsHeld = false;
    public boolean keybind_invert = false;
    public boolean blockDescriptions = true;
    public boolean displayBlockDescriptionsAlways = false;
    public boolean entityDescriptions = true;
    public boolean displayEntityDescriptionsAlways = false;
    public boolean developer_showUntranslated = false;
    public boolean developer_dontTranslate = false;
    public boolean developer_disableGenericStringDescriptions = true;
    public boolean developer_disableGenericTagDescriptions = false;

    public static void load() {
        if (!Files.exists(ModConfig.configPath(), new LinkOption[0])) {
            ModConfig.save();
            return;
        }
        try (InputStream input = Files.newInputStream(ModConfig.configPath(), new OpenOption[0]);){
            INSTANCE = (ModConfig)GSON.fromJson((Reader)new InputStreamReader(input, StandardCharsets.UTF_8), ModConfig.class);
        }
        catch (IOException e) {
            ModClient.LOGGER.warn("Unable to load config file!");
        }
    }

    public static void save() {
        try (OutputStream output = Files.newOutputStream(ModConfig.configPath(), new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(output, StandardCharsets.UTF_8);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            ModClient.LOGGER.warn("Unable to save config file!");
        }
    }

    public static ModConfig get() {
        if (INSTANCE == null) {
            INSTANCE = new ModConfig();
        }
        return INSTANCE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    static Path configPath() {
        return ModConfigImpl.configPath();
    }
}

