/*
 * Decompiled with CFR 0.152.
 */
package nicusha.ruby.materials;

import java.util.EnumMap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.EquipmentAssets;

public interface RubyArmorMaterials {
    public static final ArmorMaterial RUBY = RubyArmorMaterials.registerArmorMaterial("ruby", 650, RubyArmorMaterials.createDefenseMap(2, 5, 6, 2, 5), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_DIAMOND, 0.0f, 0.0f, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"ruby_repair")));
    public static final ArmorMaterial AMETHYST = RubyArmorMaterials.registerArmorMaterial("amethyst", 750, RubyArmorMaterials.createDefenseMap(2, 5, 6, 2, 5), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_GENERIC, 0.0f, 0.0f, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"amethyst_repair")));
    public static final ArmorMaterial BRAUNITE = RubyArmorMaterials.registerArmorMaterial("braunite", 1250, RubyArmorMaterials.createDefenseMap(2, 5, 6, 2, 5), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_NETHERITE, 0.0f, 0.0f, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"netherite_repair")));
    public static final ArmorMaterial OPAL = RubyArmorMaterials.registerArmorMaterial("opal", 250, RubyArmorMaterials.createDefenseMap(2, 5, 6, 2, 5), 30, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_CHAIN, 0.0f, 0.0f, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"opal_repair")));
    public static final ArmorMaterial METEORITE = RubyArmorMaterials.registerArmorMaterial("meteorite", 1150, RubyArmorMaterials.createDefenseMap(2, 5, 6, 2, 5), 20, (Holder<SoundEvent>)SoundEvents.ARMOR_EQUIP_IRON, 0.0f, 0.0f, (TagKey<Item>)ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)"meteorite_repair")));

    public static ResourceKey<EquipmentAsset> createId(String name) {
        return ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"ruby", (String)name));
    }

    public static EnumMap<ArmorType, Integer> createDefenseMap(int boots, int leggings, int chestplate, int helmet, int body) {
        EnumMap<ArmorType, Integer> defenseMap = new EnumMap<ArmorType, Integer>(ArmorType.class);
        defenseMap.put(ArmorType.BOOTS, boots);
        defenseMap.put(ArmorType.LEGGINGS, leggings);
        defenseMap.put(ArmorType.CHESTPLATE, chestplate);
        defenseMap.put(ArmorType.HELMET, helmet);
        defenseMap.put(ArmorType.BODY, body);
        return defenseMap;
    }

    private static ArmorMaterial registerArmorMaterial(String name, int durability, EnumMap<ArmorType, Integer> defenseMap, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, TagKey<Item> repairIngredient) {
        return RubyArmorMaterials.createArmorMaterial(durability, defenseMap, enchantmentValue, equipSound, toughness, knockbackResistance, repairIngredient, RubyArmorMaterials.createId(name));
    }

    private static ArmorMaterial createArmorMaterial(int durability, EnumMap<ArmorType, Integer> defenseMap, int enchantmentValue, Holder<SoundEvent> equipSound, float toughness, float knockbackResistance, TagKey<Item> repairIngredient, ResourceKey<EquipmentAsset> assetKey) {
        EnumMap<ArmorType, Integer> mappedDefense = new EnumMap<ArmorType, Integer>(ArmorType.class);
        for (ArmorType type : ArmorType.values()) {
            mappedDefense.put(type, defenseMap.get(type));
        }
        return new ArmorMaterial(durability, mappedDefense, enchantmentValue, equipSound, toughness, knockbackResistance, repairIngredient, assetKey);
    }
}

