/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.client.model.entity;

import com.tristankechlo.livingthings.client.model.AdvancedEntityModel;
import com.tristankechlo.livingthings.client.renderer.state.SnailRenderState;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class SnailModel<T extends SnailRenderState>
extends AdvancedEntityModel<T> {
    private final ModelPart LeftEyeStick;
    private final ModelPart RightEyeStick;

    public SnailModel(ModelPart root) {
        super(root);
        ModelPart Body = root.getChild("Body");
        this.LeftEyeStick = Body.getChild("LeftEyeStick");
        this.RightEyeStick = Body.getChild("RightEyeStick");
    }

    @Override
    protected void animate(T state, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.LeftEyeStick.zRot = Mth.cos((float)(limbSwing * 0.6662f)) * 0.4f * limbSwingAmount;
        this.RightEyeStick.zRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.4f * limbSwingAmount;
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition Body = partdefinition.addOrReplaceChild("Body", CubeListBuilder.create().texOffs(26, 14).addBox(-3.0f, -5.0f, -6.5f, 6.0f, 5.0f, 13.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition LeftEyeStick = Body.addOrReplaceChild("LeftEyeStick", CubeListBuilder.create().texOffs(42, 1).addBox(-0.5f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.7f, (float)-4.9f, (float)-5.0f, (float)0.1309f, (float)-0.1309f, (float)0.0873f));
        PartDefinition LeftEye = LeftEyeStick.addOrReplaceChild("LeftEye", CubeListBuilder.create().texOffs(5, 27).mirror().addBox(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)0.0f, (float)-3.9672f, (float)0.0f));
        PartDefinition RightEyeStick = Body.addOrReplaceChild("RightEyeStick", CubeListBuilder.create().texOffs(37, 1).addBox(-0.5f, -4.0f, -0.5f, 1.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.7f, (float)-4.9f, (float)-5.0f, (float)0.1309f, (float)0.1309f, (float)-0.0873f));
        PartDefinition RightEye = RightEyeStick.addOrReplaceChild("RightEye", CubeListBuilder.create().texOffs(0, 27).addBox(-0.5f, -3.0f, -0.5f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.9672f, (float)0.0f));
        PartDefinition Shell = Body.addOrReplaceChild("Shell", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -11.0668f, -2.9662f, 8.0f, 11.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.4508f, (float)-0.3417f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition LeftNose = Body.addOrReplaceChild("LeftNose", CubeListBuilder.create().texOffs(56, 3).addBox(-0.5f, -0.5f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.4f, (float)-2.5f, (float)-6.0f, (float)0.0f, (float)-0.1309f, (float)0.0f));
        PartDefinition RightNose = Body.addOrReplaceChild("RightNose", CubeListBuilder.create().texOffs(47, 3).addBox(-0.5f, -0.5f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.4f, (float)-2.5f, (float)-6.0f, (float)0.0f, (float)0.1309f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }
}

