/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.tristankechlo.livingthings.config.entity.ElephantConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class ElephantEntity
extends TamableAnimal
implements NeutralMob,
HasCustomInventoryScreen,
ILexiconEntry {
    public static final int ANGER_TIME = 10;
    private static final UniformInt rangedInteger = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private static Component CONTAINER_NAME = null;
    private static final EntityDataAccessor<Boolean> IS_SADDLED = SynchedEntityData.defineId(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> HAS_CHEST = SynchedEntityData.defineId(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> REMAINING_ANGER_TIME = SynchedEntityData.defineId(ElephantEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    protected SimpleContainer entityInventory;
    private int tameAmount;
    private int attackTimer;
    private UUID angerTarget;

    public ElephantEntity(EntityType<ElephantEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
        this.initInventory();
        this.tameAmount = 0;
    }

    public static boolean checkElephantSpawnRules(EntityType<ElephantEntity> animal, LevelAccessor world, EntitySpawnReason reason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(LivingThingsTags.ELEPHANT_SPAWNABLE_ON) && ElephantEntity.isBrightEnoughToSpawn((BlockAndTintGetter)world, (BlockPos)pos);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(IS_SADDLED, (Object)false);
        builder.define(HAS_CHEST, (Object)false);
        builder.define(REMAINING_ANGER_TIME, (Object)0);
    }

    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob parent) {
        ElephantEntity child = (ElephantEntity)ModEntityTypes.ELEPHANT.get().create(this.level(), EntitySpawnReason.BREEDING);
        if (this.isTame() || ((ElephantEntity)parent).isTame()) {
            child.setTame(true, false);
        }
        return child;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.TEMPT_RANGE, ElephantConfig.temptRange()).add(Attributes.MAX_HEALTH, ElephantConfig.health()).add(Attributes.MOVEMENT_SPEED, ElephantConfig.movementSpeed()).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.ATTACK_DAMAGE, ElephantConfig.attackDamage());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new BetterMeleeAttackGoal((PathfinderMob)this, 1.2, false, ElephantConfig::canAttack));
        this.goalSelector.addGoal(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new FollowParentGoal((Animal)this, 0.95));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new NewHurtByTargetGoal((PathfinderMob)this));
        this.targetSelector.addGoal(1, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.readPersistentAngerSaveData(this.level(), compound);
        this.setSaddled(compound.getBoolean("Saddled"));
        this.setHasChest(compound.getBoolean("Chested"));
        this.setTame(compound.getBoolean("Tamed"), false);
        this.tameAmount = compound.getInt("TameAmount");
        this.entityInventory.fromTag(compound.getList("Inventory", 10), (HolderLookup.Provider)this.registryAccess());
        this.initInventory();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        this.addPersistentAngerSaveData(compound);
        compound.putBoolean("Saddled", this.isSaddled());
        compound.putBoolean("Chested", this.hasChest());
        compound.putBoolean("Tamed", this.isTame());
        compound.putInt("TameAmount", this.tameAmount);
        compound.put("Inventory", (Tag)this.entityInventory.createTag((HolderLookup.Provider)this.registryAccess()));
    }

    private void initInventory() {
        SimpleContainer inventory = this.entityInventory;
        this.entityInventory = new SimpleContainer(27);
        if (inventory == null) {
            return;
        }
        int invSize = Math.min(inventory.getContainerSize(), this.entityInventory.getContainerSize());
        for (int i = 0; i < invSize; ++i) {
            ItemStack itemstack = inventory.getItem(i);
            if (itemstack.isEmpty()) continue;
            this.entityInventory.setItem(i, itemstack.copy());
        }
    }

    private void openInventory(Player player) {
        if (!this.hasChest()) {
            return;
        }
        if (CONTAINER_NAME == null) {
            CONTAINER_NAME = ModEntityTypes.ELEPHANT.get().getDescription();
        }
        player.openMenu((MenuProvider)new SimpleMenuProvider((id, playerInv, playerIn) -> new ChestMenu(MenuType.GENERIC_9x3, id, player.getInventory(), (Container)this.entityInventory, 3), CONTAINER_NAME));
    }

    public void openCustomInventoryScreen(Player player) {
        this.openInventory(player);
    }

    public boolean isFood(ItemStack stack) {
        return stack.is(LivingThingsTags.ELEPHANT_FOOD);
    }

    public boolean doHurtTarget(ServerLevel level, Entity target) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        boolean flag = super.doHurtTarget(level, target);
        if (flag) {
            target.setDeltaMovement(target.getDeltaMovement().add(0.0, 0.7, 0.0));
        }
        return flag;
    }

    public void tick() {
        super.tick();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    public int getMaxSpawnClusterSize() {
        return ElephantConfig.maxSpawnedInChunk();
    }

    protected Vec3 getPassengerAttachmentPoint(Entity rider, EntityDimensions dimensions, float scale) {
        return new Vec3(0.0, (double)(dimensions.height() * 0.975f * scale), 0.0);
    }

    protected SoundEvent getAmbientSound() {
        return ModSounds.ELEPHANT_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSounds.ELEPHANT_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ModSounds.ELEPHANT_DEATH.get();
    }

    public void handleEntityEvent(byte id) {
        switch (id) {
            case 4: {
                this.attackTimer = 10;
                break;
            }
            case 6: {
                this.spawnParticle((ParticleOptions)ParticleTypes.ENCHANTED_HIT);
                this.spawnParticle((ParticleOptions)ParticleTypes.FIREWORK);
                break;
            }
            case 7: {
                this.spawnParticle((ParticleOptions)ParticleTypes.COMPOSTER);
                break;
            }
            default: {
                super.handleEntityEvent(id);
            }
        }
    }

    private void spawnParticle(ParticleOptions particle) {
        if (particle != null) {
            for (int i = 0; i < 10; ++i) {
                double d0 = this.random.nextGaussian() * 0.03;
                double d1 = this.random.nextGaussian() * 0.03;
                double d2 = this.random.nextGaussian() * 0.03;
                this.level().addParticle(particle, this.getRandomX(1.5), this.getRandomY() + 0.5, this.getRandomZ(1.5), d0, d1, d2);
            }
        }
    }

    private void doPlayerRide(Player player) {
        if (!this.level().isClientSide()) {
            player.setYRot(this.getYRot());
            player.setXRot(this.getXRot());
            player.startRiding((Entity)this);
        }
    }

    protected boolean isImmobile() {
        return super.isImmobile() && this.isVehicle();
    }

    protected void dropEquipment(ServerLevel level) {
        super.dropEquipment(level);
        if (this.entityInventory != null) {
            for (int i = 0; i < this.entityInventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.entityInventory.getItem(i);
                if (itemstack.isEmpty() || EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP)) continue;
                this.spawnAtLocation(level, itemstack);
            }
        }
        if (this.isSaddled() && this.random.nextBoolean()) {
            this.spawnAtLocation(level, (ItemLike)Items.SADDLE);
        }
        if (this.hasChest() && this.random.nextBoolean()) {
            this.spawnAtLocation(level, (ItemLike)Items.CHEST);
        }
    }

    public void travel(Vec3 travelVector) {
        if (this.isAlive()) {
            if (this.isVehicle() && this.isControlledByLocalInstance() && this.isSaddled()) {
                LivingEntity livingentity = this.getControllingPassenger();
                this.setYRot(livingentity.getYRot());
                this.yRotO = this.getYRot();
                this.setXRot(livingentity.getXRot() * 0.5f);
                this.setRot(this.getYRot(), this.getXRot());
                this.yHeadRot = this.yBodyRot = this.getYRot();
                float sideSpeed = livingentity.xxa * 0.4f;
                float forwardSpeed = livingentity.zza * 0.7f;
                if (forwardSpeed <= 0.0f) {
                    forwardSpeed *= 0.2f;
                }
                if (this.isControlledByLocalInstance()) {
                    this.setSpeed((float)this.getAttributeValue(Attributes.MOVEMENT_SPEED));
                    super.travel(new Vec3((double)sideSpeed, travelVector.y, (double)forwardSpeed));
                } else if (livingentity instanceof Player) {
                    this.setDeltaMovement(Vec3.ZERO);
                }
                this.calculateEntityAnimation(false);
            } else {
                super.travel(travelVector);
            }
        }
    }

    public boolean isTamingItem(ItemStack stack) {
        return stack.is(LivingThingsTags.ELEPHANT_TAMING_FOOD);
    }

    public LivingEntity getControllingPassenger() {
        Entity passenger = this.getFirstPassenger();
        if (passenger instanceof Player) {
            return (Player)passenger;
        }
        return null;
    }

    public boolean isSaddled() {
        return (Boolean)this.entityData.get(IS_SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.entityData.set(IS_SADDLED, (Object)saddled);
    }

    public boolean hasChest() {
        return (Boolean)this.entityData.get(HAS_CHEST);
    }

    public void setHasChest(boolean chested) {
        this.entityData.set(HAS_CHEST, (Object)chested);
    }

    public int getAttackTimer() {
        return this.attackTimer;
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int time) {
        this.entityData.set(REMAINING_ANGER_TIME, (Object)time);
    }

    public UUID getPersistentAngerTarget() {
        return this.angerTarget;
    }

    public void setPersistentAngerTarget(UUID target) {
        this.angerTarget = target;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(rangedInteger.sample(this.random));
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getMainHandItem();
        if (stack.is(ModItems.LEXICON.get())) {
            return InteractionResult.PASS;
        }
        if (stack.isEmpty() && this.isTame() && !this.isBaby()) {
            if (player.isCrouching() && this.hasChest()) {
                this.openInventory(player);
            } else if (this.getPassengers().isEmpty() && this.isSaddled()) {
                this.doPlayerRide(player);
            }
            return this.level().isClientSide() ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
        }
        if (this.isFood(stack)) {
            if (this.isBaby()) {
                int age = this.getAge();
                this.usePlayerItem(player, hand, stack);
                this.ageUp((int)((float)(-age / 20) * 0.1f), true);
                return this.level().isClientSide() ? InteractionResult.SUCCESS : InteractionResult.SUCCESS_SERVER;
            }
            if (this.isTame()) {
                if (this.getHealth() < this.getMaxHealth()) {
                    if (!this.level().isClientSide()) {
                        float healAmount = 3.0f;
                        this.heal(healAmount);
                        this.usePlayerItem(player, hand, stack);
                        return InteractionResult.SUCCESS_SERVER;
                    }
                } else if (!this.level().isClientSide() && !this.isBaby() && this.canBreed()) {
                    this.usePlayerItem(player, hand, stack);
                    this.setInLove(player);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.SUCCESS;
            }
        } else {
            if (this.isTamingItem(stack) && !this.isBaby() && !this.isTame()) {
                if (!this.level().isClientSide()) {
                    this.tameAmount += 200;
                    this.usePlayerItem(player, hand, stack);
                    if (this.tameAmount >= 1000) {
                        this.setTame(true, true);
                        this.setOwnerUUID(player.getUUID());
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.TAME_ANIMAL.trigger((ServerPlayer)player, (Animal)this);
                        }
                        this.level().broadcastEntityEvent((Entity)this, (byte)6);
                    } else {
                        this.level().broadcastEntityEvent((Entity)this, (byte)7);
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isTame() && stack.is(Items.SADDLE) && !this.isBaby() && !this.isSaddled()) {
                if (!this.level().isClientSide()) {
                    this.usePlayerItem(player, hand, stack);
                    this.setSaddled(true);
                    this.playSound(ModSounds.ELEPHANT_EQUIP_SADDLE.get(), 0.9f, 0.9f);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.SUCCESS;
            }
            if (this.isTame() && this.isSaddled() && stack.is(Items.CHEST) && !this.isBaby() && !this.hasChest()) {
                if (!this.level().isClientSide()) {
                    this.usePlayerItem(player, hand, stack);
                    this.setHasChest(true);
                    this.playSound(ModSounds.ELEPHANT_EQUIP_CHEST.get(), 0.9f, 0.9f);
                    return InteractionResult.SUCCESS_SERVER;
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public boolean canBreed() {
        return this.canFallInLove();
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.ELEPHANT;
    }

    private static class NewHurtByTargetGoal
    extends HurtByTargetGoal {
        public NewHurtByTargetGoal(PathfinderMob creatureIn) {
            super(creatureIn, new Class[0]);
        }

        protected boolean canAttack(LivingEntity entity, TargetingConditions conditions) {
            UUID ownerID;
            if (entity instanceof Player && (ownerID = ((ElephantEntity)this.mob).getOwnerUUID()) != null && entity.getUUID().equals(ownerID)) {
                return false;
            }
            return super.canAttack(entity, conditions);
        }
    }
}

