/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity.projectile;

import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModItems;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrownOstrichEgg
extends ThrowableItemProjectile {
    public ThrownOstrichEgg(EntityType<? extends ThrownOstrichEgg> type, Level world) {
        super(type, world);
    }

    public ThrownOstrichEgg(double x, double y, double z, Level level, ItemStack stack) {
        super(ModEntityTypes.THROWN_OSTRICH_EGG.get(), x, y, z, level, stack);
        this.setItem(stack);
    }

    public ThrownOstrichEgg(LivingEntity owner, Level level, ItemStack stack) {
        this(owner.getX(), owner.getEyeY() - (double)0.1f, owner.getZ(), level, stack);
        this.setOwner((Entity)owner);
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        super.onHitEntity(hitResult);
        hitResult.getEntity().hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 1.0f);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.discard();
        }
    }

    public void handleEntityEvent(byte eventID) {
        if (eventID == 3) {
            double offset = 0.18;
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, this.getItem()), this.getX(), this.getY(), this.getZ(), ((double)this.random.nextFloat() - 0.5) * offset, ((double)this.random.nextFloat() - 0.5) * offset, ((double)this.random.nextFloat() - 0.5) * offset);
            }
        }
    }

    protected Item getDefaultItem() {
        return ModItems.OSTRICH_EGG.get();
    }
}

