/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.init;

import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.init.ModFoods;
import com.tristankechlo.livingthings.init.ModSounds;
import com.tristankechlo.livingthings.init.RegistryHelper;
import com.tristankechlo.livingthings.item.LexiconItem;
import com.tristankechlo.livingthings.item.OstrichEggItem;
import com.tristankechlo.livingthings.platform.IPlatformHelper;
import com.tristankechlo.livingthings.platform.RegistrationProvider;
import com.tristankechlo.livingthings.platform.RegistryObject;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.EquipmentAssets;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class ModItems {
    public static final RegistrationProvider<Item> ITEMS = RegistrationProvider.get(BuiltInRegistries.ITEM, "livingthings");
    public static final List<RegistryObject<? extends Item>> ALL_ITEMS = new ArrayList<RegistryObject<? extends Item>>();
    public static final List<RegistryObject<Item>> SPAWN_EGGS = new ArrayList<RegistryObject<Item>>();
    public static final RegistryObject<Item> SHARK_TOOTH = ModItems.registerItem("shark_tooth", Item::new);
    public static final RegistryObject<Item> OSTRICH_EGG = ModItems.registerItem("ostrich_egg", p -> new OstrichEggItem(p.stacksTo(16)));
    public static final RegistryObject<Item> CRAB = ModItems.registerFoodItem("crab", ModFoods.CRAB);
    public static final RegistryObject<Item> COOKED_CRAB = ModItems.registerFoodItem("cooked_crab", ModFoods.COOKED_CRAB);
    public static final RegistryObject<Item> CRAB_SHELL = ModItems.registerItem("crab_shell", Item::new);
    public static final RegistryObject<Item> LEXICON = ModItems.registerItem("lexicon", p -> new LexiconItem(p.stacksTo(1)));
    public static final RegistryObject<Item> BANANA = ModItems.registerFoodItem("banana", ModFoods.BANANA);
    public static final RegistryObject<Item> ANCIENT_HELMET = ModItems.registerArmorItem("ancient_helmet");
    public static final RegistryObject<Item> OSTRICH = ModItems.registerFoodItem("ostrich", ModFoods.OSTRICH);
    public static final RegistryObject<Item> COOKED_OSTRICH = ModItems.registerFoodItem("cooked_ostrich", ModFoods.COOKED_OSTRICH);
    public static final RegistryObject<Item> ELEPHANT = ModItems.registerFoodItem("elephant", ModFoods.ELEPHANT);
    public static final RegistryObject<Item> COOKED_ELEPHANT = ModItems.registerFoodItem("cooked_elephant", ModFoods.COOKED_ELEPHANT);
    public static final RegistryObject<Item> LION = ModItems.registerFoodItem("lion", ModFoods.LION);
    public static final RegistryObject<Item> COOKED_LION = ModItems.registerFoodItem("cooked_lion", ModFoods.COOKED_LION);
    public static final RegistryObject<Item> GIRAFFE = ModItems.registerFoodItem("giraffe", ModFoods.GIRAFFE);
    public static final RegistryObject<Item> COOKED_GIRAFFE = ModItems.registerFoodItem("cooked_giraffe", ModFoods.COOKED_GIRAFFE);
    public static final RegistryObject<Item> SEAHORSE_BUCKET = ModItems.registerItem("seahorse_bucket", p -> IPlatformHelper.INSTANCE.createMobBucketItem(ModEntityTypes.SEAHORSE, (Fluid)Fluids.WATER, SoundEvents.BUCKET_EMPTY_FISH, p.stacksTo(1)));
    public static final RegistryObject<Item> ELEPHANT_SPAWN_EGG = ModItems.registerSpawnEgg("elephant_spawn_egg", ModEntityTypes.ELEPHANT::get);
    public static final RegistryObject<Item> GIRAFFE_SPAWN_EGG = ModItems.registerSpawnEgg("giraffe_spawn_egg", ModEntityTypes.GIRAFFE::get);
    public static final RegistryObject<Item> LION_SPAWN_EGG = ModItems.registerSpawnEgg("lion_spawn_egg", ModEntityTypes.LION::get);
    public static final RegistryObject<Item> SHARK_SPAWN_EGG = ModItems.registerSpawnEgg("shark_spawn_egg", ModEntityTypes.SHARK::get);
    public static final RegistryObject<Item> PENGUIN_SPAWN_EGG = ModItems.registerSpawnEgg("penguin_spawn_egg", ModEntityTypes.PENGUIN::get);
    public static final RegistryObject<Item> OSTRICH_SPAWN_EGG = ModItems.registerSpawnEgg("ostrich_spawn_egg", ModEntityTypes.OSTRICH::get);
    public static final RegistryObject<Item> FLAMINGO_SPAWN_EGG = ModItems.registerSpawnEgg("flamingo_spawn_egg", ModEntityTypes.FLAMINGO::get);
    public static final RegistryObject<Item> CRAB_SPAWN_EGG = ModItems.registerSpawnEgg("crab_spawn_egg", ModEntityTypes.CRAB::get);
    public static final RegistryObject<Item> MANTARAY_SPAWN_EGG = ModItems.registerSpawnEgg("mantaray_spawn_egg", ModEntityTypes.MANTARAY::get);
    public static final RegistryObject<Item> RACCOON_SPAWN_EGG = ModItems.registerSpawnEgg("raccoon_spawn_egg", ModEntityTypes.RACCOON::get);
    public static final RegistryObject<Item> OWL_SPAWN_EGG = ModItems.registerSpawnEgg("owl_spawn_egg", ModEntityTypes.OWL::get);
    public static final RegistryObject<Item> ANCIENT_BLAZE_SPAWN_EGG = ModItems.registerSpawnEgg("ancient_blaze_spawn_egg", ModEntityTypes.ANCIENT_BLAZE::get);
    public static final RegistryObject<Item> KOALA_SPAWN_EGG = ModItems.registerSpawnEgg("koala_spawn_egg", ModEntityTypes.KOALA::get);
    public static final RegistryObject<Item> SNAIL_SPAWN_EGG = ModItems.registerSpawnEgg("snail_spawn_egg", ModEntityTypes.SNAIL::get);
    public static final RegistryObject<Item> MONKEY_SPAWN_EGG = ModItems.registerSpawnEgg("monkey_spawn_egg", ModEntityTypes.MONKEY::get);
    public static final RegistryObject<Item> NETHER_KNIGHT_SPAWN_EGG = ModItems.registerSpawnEgg("nether_knight_spawn_egg", ModEntityTypes.NETHER_KNIGHT::get);
    public static final RegistryObject<Item> SHROOMIE_SPAWN_EGG = ModItems.registerSpawnEgg("shroomie_spawn_egg", ModEntityTypes.SHROOMIE::get);
    public static final RegistryObject<Item> SEAHORSE_SPAWN_EGG = ModItems.registerSpawnEgg("seahorse_spawn_egg", ModEntityTypes.SEAHORSE::get);
    public static final RegistryObject<Item> BABY_ENDER_DRAGON_SPAWN_EGG = ModItems.registerSpawnEgg("baby_ender_dragon_spawn_egg", ModEntityTypes.BABY_ENDER_DRAGON::get);
    public static final RegistryObject<Item> PEACOCK_SPAWN_EGG = ModItems.registerSpawnEgg("peacock_spawn_egg", ModEntityTypes.PEACOCK::get);

    public static void init() {
    }

    private static RegistryObject<Item> registerItem(String name, Function<Item.Properties, Item> item) {
        Item.Properties p = new Item.Properties().setId(RegistryHelper.itemId(name)).useItemDescriptionPrefix();
        RegistryObject<Item> registeredItem = ITEMS.register(name, () -> (Item)item.apply(p));
        ALL_ITEMS.add(registeredItem);
        return registeredItem;
    }

    private static RegistryObject<Item> registerArmorItem(String name) {
        ResourceLocation modelId = ResourceLocation.fromNamespaceAndPath((String)"livingthings", (String)"ancient_armor_model");
        ResourceKey assetKey = ResourceKey.create((ResourceKey)EquipmentAssets.ROOT_ID, (ResourceLocation)modelId);
        return ModItems.registerItem(name, p -> {
            p.stacksTo(1).durability(20).repairable(LivingThingsTags.REPAIRS_ANCIENT_HELMET).equippable(EquipmentSlot.HEAD).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.HEAD).setEquipSound(ModSounds.ANCIENT_ARMOR_EQUIP.asHolder()).setAsset(assetKey).build()).attributes(ModItems.createAttributes(ArmorType.HELMET, 3, 2.0f));
            return new Item(p);
        });
    }

    private static ItemAttributeModifiers createAttributes(ArmorType armorType, int defense, float toughness) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        EquipmentSlotGroup group = EquipmentSlotGroup.bySlot((EquipmentSlot)armorType.getSlot());
        ResourceLocation rl = ResourceLocation.fromNamespaceAndPath((String)"livingthings", (String)("armor." + armorType.getName()));
        builder.add(Attributes.ARMOR, new AttributeModifier(rl, (double)defense, AttributeModifier.Operation.ADD_VALUE), group);
        builder.add(Attributes.ARMOR_TOUGHNESS, new AttributeModifier(rl, (double)toughness, AttributeModifier.Operation.ADD_VALUE), group);
        return builder.build();
    }

    private static RegistryObject<Item> registerFoodItem(String name, FoodProperties food) {
        return ModItems.registerItem(name, p -> new Item(p.food(food)));
    }

    private static RegistryObject<Item> registerSpawnEgg(String name, Supplier<EntityType<? extends Mob>> type) {
        Item.Properties p = new Item.Properties().setId(RegistryHelper.itemId(name)).useItemDescriptionPrefix();
        RegistryObject<Item> registeredItem = ITEMS.register(name, () -> new SpawnEggItem((EntityType)type.get(), p));
        SPAWN_EGGS.add(registeredItem);
        return registeredItem;
    }
}

