/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.minetraps.utils.Config;

public class BlockChestBomb
extends Block {
    protected static final VoxelShape CUSTOM_SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)15.0);

    public BlockChestBomb(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CUSTOM_SHAPE;
    }

    public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
        AreaEffectCloud dummy = new AreaEffectCloud((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        if (!level.isClientSide) {
            level.explode((Entity)dummy, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), 3.0f, true, Level.ExplosionInteraction.TNT);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        AreaEffectCloud dummy = new AreaEffectCloud(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        level.playSound((Player)null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 1.0f, 3.0f);
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        if (!level.isClientSide) {
            level.explode((Entity)dummy, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (float)((Integer)Config.CHEST_BOMB_EXPLOSION_RADIUS.get()).intValue(), true, Level.ExplosionInteraction.TNT);
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{BlockStateProperties.HORIZONTAL_FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }
}

