/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.minetraps.registry.ModBlocks;
import xxrexraptorxx.minetraps.utils.Config;

public class BlockExplosiveMine
extends FallingBlock {
    protected static final VoxelShape CUSTOM_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public BlockExplosiveMine(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CUSTOM_SHAPE;
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        world.playSound((Player)null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.METAL_PRESSURE_PLATE_CLICK_ON, SoundSource.BLOCKS, 1.0f, 3.0f);
        if (!world.isClientSide) {
            if (this == ModBlocks.TOXIC_MINE.get()) {
                AreaEffectCloud cloud = new AreaEffectCloud(world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                cloud.addEffect(new MobEffectInstance(MobEffects.POISON, ((Integer)Config.POSION_MINE_EFFECT_DURATION.get()).intValue(), ((Integer)Config.POSION_MINE_EFFECT_AMPLIFIER.get()).intValue()));
                cloud.setDuration(((Integer)Config.POSION_MINE_CLOUD_DURATION.get()).intValue());
                cloud.setRadius(10.0f);
                cloud.setWaitTime(10);
                world.addFreshEntity((Entity)cloud);
            }
            entity.hurt(world.damageSources().generic(), (float)((Integer)Config.MINE_DAMAGE.get()).intValue());
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            world.explode(entity, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (float)((Integer)Config.MINE_EXPLOSION_RADIUS.get()).intValue(), true, Level.ExplosionInteraction.TNT);
        }
    }

    public void onBlockExploded(BlockState state, ServerLevel world, BlockPos pos, Explosion explosion) {
        AreaEffectCloud cloud = new AreaEffectCloud((Level)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (!world.isClientSide) {
            if (this == ModBlocks.TOXIC_MINE.get()) {
                cloud.addEffect(new MobEffectInstance(MobEffects.POISON, ((Integer)Config.POSION_MINE_EFFECT_DURATION.get()).intValue(), ((Integer)Config.POSION_MINE_EFFECT_AMPLIFIER.get()).intValue()));
                cloud.setDuration(((Integer)Config.POSION_MINE_CLOUD_DURATION.get()).intValue());
                cloud.setRadius(10.0f);
                cloud.setWaitTime(10);
                world.addFreshEntity((Entity)cloud);
            }
            world.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
            world.explode((Entity)cloud, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (float)((Integer)Config.MINE_EXPLOSION_RADIUS.get()).intValue(), true, Level.ExplosionInteraction.TNT);
        }
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return BlockExplosiveMine.canSupportCenter((LevelReader)pLevel, (BlockPos)pPos.below(), (Direction)Direction.DOWN);
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return null;
    }
}

