/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xxrexraptorxx.minetraps.registry.ModBlocks;
import xxrexraptorxx.minetraps.utils.Config;

public class BlockNailTrap
extends FallingBlock {
    protected static final VoxelShape CUSTOM_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public BlockNailTrap(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return CUSTOM_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return BlockNailTrap.canSupportCenter((LevelReader)pLevel, (BlockPos)pPos.below(), (Direction)Direction.DOWN);
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        if (!level.isClientSide && !entityIn.isCrouching() && entityIn instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)entityIn;
            if (this == ModBlocks.TOXIC_NAIL_TRAP.get()) {
                entity.addEffect(new MobEffectInstance(MobEffects.POISON, ((Integer)Config.TOXIC_NAIL_TRAP_EFFECT_DURATION.get()).intValue(), ((Integer)Config.TOXIC_NAIL_TRAP_EFFECT_AMPLIFIER.get()).intValue()));
            }
            entity.hurt(level.damageSources().generic(), (float)((Integer)Config.NAIL_TRAP_DAMAGE.get()).intValue());
        }
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return null;
    }
}

