/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import xxrexraptorxx.minetraps.registry.ModBlocks;
import xxrexraptorxx.minetraps.utils.Config;
import xxrexraptorxx.minetraps.utils.TrollHelper;

public class BlockTroll
extends Block {
    public static final IntegerProperty TYPE = IntegerProperty.create((String)"type", (int)0, (int)8);

    public BlockTroll(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)Integer.valueOf(0)));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"message.minetraps.troll.desc").withStyle(ChatFormatting.GRAY));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{TYPE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)TYPE, (Comparable)Integer.valueOf(0));
    }

    public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
        AreaEffectCloud dummy = new AreaEffectCloud((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        if (!level.isClientSide) {
            level.explode((Entity)dummy, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (float)((Integer)Config.EXPLOSIVE_BLOCK_RADIUS.get()).intValue(), true, Level.ExplosionInteraction.TNT);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        AreaEffectCloud dummy = new AreaEffectCloud(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        level.playSound((Player)null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS, 1.0f, 3.0f);
        level.setBlock(pos, Blocks.AIR.defaultBlockState(), 11);
        if (!level.isClientSide) {
            level.explode((Entity)dummy, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (float)((Integer)Config.EXPLOSIVE_BLOCK_RADIUS.get()).intValue(), true, Level.ExplosionInteraction.TNT);
        }
        return true;
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (state.getBlock() == ModBlocks.TROLL_BLOCK.get() && (Integer)state.getValue((Property)TYPE) == 0) {
            InteractionHand hand = player.getUsedItemHand();
            if (TrollHelper.getTypeList().contains(player.getItemInHand(hand).getItem())) {
                level.setBlock(pos, (BlockState)state.setValue((Property)TYPE, (Comparable)Integer.valueOf(TrollHelper.getStateFromBlock(BuiltInRegistries.ITEM.getKey((Object)player.getItemInHand(hand).getItem()).toString()))), 2);
                if (!player.isCreative()) {
                    player.getItemInHand(hand).shrink(1);
                }
            }
        }
        return InteractionResult.SUCCESS;
    }
}

