/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.registry;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import xxrexraptorxx.minetraps.blocks.BlockBarbedWire;
import xxrexraptorxx.minetraps.blocks.BlockBarbedWireFence;
import xxrexraptorxx.minetraps.blocks.BlockBearTrap;
import xxrexraptorxx.minetraps.blocks.BlockChestBomb;
import xxrexraptorxx.minetraps.blocks.BlockExplosiveMine;
import xxrexraptorxx.minetraps.blocks.BlockGhost;
import xxrexraptorxx.minetraps.blocks.BlockNailTrap;
import xxrexraptorxx.minetraps.blocks.BlockObstacle;
import xxrexraptorxx.minetraps.blocks.BlockPitfallTrap;
import xxrexraptorxx.minetraps.blocks.BlockQuicksand;
import xxrexraptorxx.minetraps.blocks.BlockSpikes;
import xxrexraptorxx.minetraps.blocks.BlockToxin;
import xxrexraptorxx.minetraps.blocks.BlockTroll;
import xxrexraptorxx.minetraps.registry.ModFluids;
import xxrexraptorxx.minetraps.registry.ModItems;

public class ModBlocks {
    private static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"minetraps");
    public static final DeferredBlock<BlockBarbedWire> BARBED_WIRE = ModBlocks.registerBlock("barbed_wire", properties -> new BlockBarbedWire(properties.requiresCorrectToolForDrops().strength(5.0f, 10.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.PLING).noCollission().noOcclusion()));
    public static final DeferredBlock<BlockBarbedWireFence> BARBED_WIRE_FENCE = ModBlocks.registerBlock("barbed_wire_fence", properties -> new BlockBarbedWireFence(properties.requiresCorrectToolForDrops().strength(5.0f, 10.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.PLING).noOcclusion().noCollission()));
    public static final DeferredBlock<BlockBarbedWire> RAZOR_WIRE = ModBlocks.registerBlock("razor_wire", properties -> new BlockBarbedWire(properties.requiresCorrectToolForDrops().strength(5.0f, 10.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.PLING).noCollission().noOcclusion()));
    public static final DeferredBlock<BlockBearTrap> BEAR_TRAP = ModBlocks.registerBlock("bear_trap", properties -> new BlockBearTrap(properties.requiresCorrectToolForDrops().strength(5.0f, 10.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.PLING).noOcclusion().noCollission()));
    public static final DeferredBlock<BlockChestBomb> CHEST_BOMB = ModBlocks.registerBlock("chest_bomb", properties -> new BlockChestBomb(properties.requiresCorrectToolForDrops().strength(2.5f, 0.0f).sound(SoundType.WOOD).mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS)));
    public static final DeferredBlock<BlockExplosiveMine> EXPLOSIVE_MINE = ModBlocks.registerBlock("explosive_mine", properties -> new BlockExplosiveMine(properties.requiresCorrectToolForDrops().strength(1.0f, 0.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.IRON_XYLOPHONE).noOcclusion().noCollission()));
    public static final DeferredBlock<BlockExplosiveMine> TOXIC_MINE = ModBlocks.registerBlock("toxic_mine", properties -> new BlockExplosiveMine(properties.requiresCorrectToolForDrops().strength(1.0f, 0.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.IRON_XYLOPHONE).noOcclusion().noCollission()));
    public static final DeferredBlock<BlockQuicksand> QUICK_SAND = ModBlocks.registerBlock("quicksand", properties -> new BlockQuicksand(properties.strength(0.65f, 0.0f).sound(SoundType.SAND).mapColor(MapColor.SAND).instrument(NoteBlockInstrument.SNARE).noOcclusion()));
    public static final DeferredBlock<BlockObstacle> OBSTACLE = ModBlocks.registerBlock("obstacle", properties -> new BlockObstacle(properties.requiresCorrectToolForDrops().strength(20.0f, 20.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.IRON_XYLOPHONE).noOcclusion()));
    public static final DeferredBlock<BlockNailTrap> NAIL_TRAP = ModBlocks.registerBlock("nail_trap", properties -> new BlockNailTrap(properties.requiresCorrectToolForDrops().strength(1.0f, 8.0f).sound(SoundType.GRAVEL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.BELL).noOcclusion().noCollission()));
    public static final DeferredBlock<BlockNailTrap> TOXIC_NAIL_TRAP = ModBlocks.registerBlock("toxic_nail_trap", properties -> new BlockNailTrap(properties.requiresCorrectToolForDrops().strength(1.0f, 8.0f).sound(SoundType.GRAVEL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.BELL).noOcclusion().noCollission()));
    public static final DeferredBlock<BlockSpikes> SPIKES = ModBlocks.registerBlock("spikes", properties -> new BlockSpikes(properties.requiresCorrectToolForDrops().strength(1.8f, 7.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.BELL).noCollission().noOcclusion()));
    public static final DeferredBlock<BlockSpikes> TOXIC_SPIKES = ModBlocks.registerBlock("spikes_toxic", properties -> new BlockSpikes(properties.requiresCorrectToolForDrops().strength(1.8f, 7.0f).sound(SoundType.METAL).mapColor(MapColor.METAL).instrument(NoteBlockInstrument.BELL).noCollission().noOcclusion()));
    public static final DeferredBlock<BlockPitfallTrap> PITFALL_TRAP = ModBlocks.registerBlock("pitfall_trap", properties -> new BlockPitfallTrap(properties.strength(1.0f, 1.0f).sound(SoundType.WOOD).mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).noOcclusion().noCollission()));
    public static final DeferredBlock<BlockGhost> GHOST_BLOCK = ModBlocks.registerBlock("ghost_block", properties -> new BlockGhost(properties.strength(1.5f, 6.0f).sound(SoundType.STONE).mapColor(MapColor.STONE).instrument(NoteBlockInstrument.XYLOPHONE).noCollission().noOcclusion()));
    public static final DeferredBlock<BlockTroll> TROLL_BLOCK = ModBlocks.registerBlock("troll_block", properties -> new BlockTroll(properties.strength(1.5f, 6.0f).sound(SoundType.STONE).mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BELL).noLootTable()));
    public static final DeferredBlock<BlockToxin> TOXIN = BLOCKS.register("toxin", () -> new BlockToxin((Supplier<? extends FlowingFluid>)ModFluids.TOXIN, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).setId(ModBlocks.blockId("toxin"))));

    public static void init(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }

    public static <T extends Block> DeferredBlock<T> registerBlock(String name, Function<BlockBehaviour.Properties, T> blockCreator) {
        DeferredBlock toReturn = BLOCKS.register(name, () -> (Block)blockCreator.apply(BlockBehaviour.Properties.of().setId(ModBlocks.blockId(name))));
        ModBlocks.registerBlockItems(name, toReturn);
        return toReturn;
    }

    public static <T extends Block> void registerBlockItems(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties().setId(ModItems.itemId(name)).useBlockDescriptionPrefix()));
    }

    public static ResourceKey<Block> blockId(String name) {
        return ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minetraps", (String)name));
    }
}

