/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ClientConfigs {
    public static final ClientConfigs INSTANCE;
    public static final ModConfigSpec SPEC;
    public final ModConfigSpec.IntValue riftLayers;
    public final ModConfigSpec.IntValue riftRenderDistance;
    public final ModConfigSpec.IntValue riftExplosionParticles;
    public final ModConfigSpec.DoubleValue riftZOffset;
    public final ModConfigSpec.DoubleValue riftLayerStart;
    public final ModConfigSpec.DoubleValue riftLayerGrowth;
    public final ModConfigSpec.DoubleValue riftMinOpacity;
    public final ModConfigSpec.DoubleValue riftMaxOpacity;
    public final ModConfigSpec.DoubleValue riftExplosionParticleRange;
    public final ModConfigSpec.BooleanValue vanillaOnly;

    public ClientConfigs(ModConfigSpec.Builder builder) {
        builder.comment("Multiverse client-side configuration");
        this.riftLayers = builder.comment("This is the number of layers to render rifts with").defineInRange("riftLayers", 3, 1, Integer.MAX_VALUE);
        this.riftZOffset = builder.comment("This is the offset in blocks for each rift layer to combat Z-fighting. ").defineInRange("riftZOffset", 5.0E-4, 0.0, Double.MAX_VALUE);
        this.riftLayerStart = builder.comment("This is the fraction of the width/height of the rift that the first layer starts. ").defineInRange("riftLayerStart", 0.75, 0.0, 1.0);
        this.riftLayerGrowth = builder.comment("This is the rate that the distance between rift layer grows using an exponential function. ").defineInRange("riftLayerGrowth", 0.5, 0.0, Double.MAX_VALUE);
        this.riftMinOpacity = builder.comment("This is the minimum opacity of a rift's layers as a fraction. ").defineInRange("riftMinOpacity", 0.5, 0.0, 1.0);
        this.riftMaxOpacity = builder.comment("This is the maximum opacity of a rift's layers as a fraction. Must be at least riftMinOpacity. ").defineInRange("riftMaxOpacity", 1.0, 0.0, 1.0);
        this.riftRenderDistance = builder.comment("This is the distance in blocks that rift blocks are rendered. ").defineInRange("riftRenderDistance", 256, 0, Integer.MAX_VALUE);
        this.riftExplosionParticleRange = builder.comment("This is the max distance in blocks that rift explosion particles will spawn from the center. ").defineInRange("riftExplosionParticleRange", 4.0, 0.0, Double.MAX_VALUE);
        this.riftExplosionParticles = builder.comment("This is the number of rift explosion particles spawned per tick. ").defineInRange("riftExplosionParticles", 6, 0, Integer.MAX_VALUE);
        this.vanillaOnly = builder.comment("This is whether only vanilla shaders are used to render. Try setting to true if rifts are invisible due to custom shaders. ").define("vanillaOnly", false);
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(ClientConfigs::new);
        INSTANCE = (ClientConfigs)pair.getLeft();
        SPEC = (ModConfigSpec)pair.getRight();
    }
}

