/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client;

import io.github.davidqf555.minecraft.multiverse.client.ColoredFogEffect;
import io.github.davidqf555.minecraft.multiverse.client.ShaderHelper;
import io.github.davidqf555.minecraft.multiverse.client.colors.KaleiditeCurrentColor;
import io.github.davidqf555.minecraft.multiverse.client.colors.KaleiditeTargetColor;
import io.github.davidqf555.minecraft.multiverse.client.particles.RiftExplosionParticle;
import io.github.davidqf555.minecraft.multiverse.client.particles.RiftExplosionSeedParticle;
import io.github.davidqf555.minecraft.multiverse.client.particles.RiftParticle;
import io.github.davidqf555.minecraft.multiverse.client.render.ConquerorRenderer;
import io.github.davidqf555.minecraft.multiverse.client.render.DoppelgangerRenderer;
import io.github.davidqf555.minecraft.multiverse.client.render.RiftTileEntityRenderer;
import io.github.davidqf555.minecraft.multiverse.client.render.TravelerRenderer;
import io.github.davidqf555.minecraft.multiverse.client.render.WarpShieldRenderer;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.DimensionEffectsRegistry;
import io.github.davidqf555.minecraft.multiverse.registration.BlockRegistry;
import io.github.davidqf555.minecraft.multiverse.registration.EntityRegistry;
import io.github.davidqf555.minecraft.multiverse.registration.ParticleTypeRegistry;
import io.github.davidqf555.minecraft.multiverse.registration.TileEntityRegistry;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.event.RegisterShadersEvent;
import net.neoforged.neoforge.client.event.RegisterSpecialModelRendererEvent;

@EventBusSubscriber(modid="multiverse", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ClientEventBusSubscriber {
    private ClientEventBusSubscriber() {
    }

    @SubscribeEvent
    public static void onRegisterEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)TileEntityRegistry.RIFT.get(), dispatcher -> new RiftTileEntityRenderer());
        event.registerEntityRenderer((EntityType)EntityRegistry.TRAVELER.get(), TravelerRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.DOPPELGANGER.get(), DoppelgangerRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.KALEIDITE_CORE.get(), ThrownItemRenderer::new);
        event.registerEntityRenderer((EntityType)EntityRegistry.CONQUEROR.get(), ConquerorRenderer::new);
    }

    @SubscribeEvent
    public static void onRegisterShaders(RegisterShadersEvent event) {
        event.registerShader(ShaderHelper.RIFT_SHADER);
        event.registerShader(ShaderHelper.RIFT_PARTICLE_SHADER);
    }

    @SubscribeEvent
    public static void onRegisterDimensionSpecialEffects(RegisterDimensionSpecialEffectsEvent event) {
        DimensionEffectsRegistry.FOG.forEach((loc, color) -> event.register(loc, (DimensionSpecialEffects)new ColoredFogEffect((int)color)));
    }

    @SubscribeEvent
    public static void onRegisterBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)KaleiditeCurrentColor.Block.INSTANCE, new Block[]{(Block)BlockRegistry.KALEIDITE_CLUSTER.get()});
    }

    @SubscribeEvent
    public static void onRegisterSpecialModelRenderer(RegisterSpecialModelRendererEvent event) {
        event.register(WarpShieldRenderer.LOCATION, WarpShieldRenderer.Unbaked.CODEC);
    }

    @SubscribeEvent
    public static void onRegisterItemColorHandlers(RegisterColorHandlersEvent.ItemTintSources event) {
        event.register(KaleiditeTargetColor.LOCATION, KaleiditeTargetColor.CODEC);
        event.register(KaleiditeCurrentColor.Item.LOCATION, KaleiditeCurrentColor.Item.CODEC);
    }

    @SubscribeEvent
    public static void onRegisterParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ParticleTypeRegistry.RIFT.get(), RiftParticle.Provider::new);
        event.registerSpriteSet((ParticleType)ParticleTypeRegistry.RIFT_EXPLOSION.get(), RiftExplosionParticle.Provider::new);
        event.registerSpecial((ParticleType)ParticleTypeRegistry.RIFT_EXPLOSION_EMITTER.get(), (ParticleProvider)new RiftExplosionSeedParticle.Provider());
    }
}

