/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client.colors;

import java.util.Random;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ARGB;
import net.minecraft.world.level.Level;

public final class MultiverseColorHelper {
    private static final long FACTOR = 55555L;
    private static final Random RANDOM = new Random(0L);

    private MultiverseColorHelper() {
    }

    private static int getColor(Random rand) {
        int[] color = new int[]{rand.nextInt(256), rand.nextInt(256), rand.nextInt(256)};
        MultiverseColorHelper.shift(color, rand);
        return ARGB.color((int)255, (int)color[0], (int)color[1], (int)color[2]);
    }

    public static int getColor(Level world, ResourceKey<Level> dim) {
        return MultiverseColorHelper.getColor(MultiverseColorHelper.getSeed(world.getBiomeManager().biomeZoomSeed, dim));
    }

    public static int getColor(Level level) {
        return MultiverseColorHelper.getColor(level, (ResourceKey<Level>)level.dimension());
    }

    private static long getSeed(long base, ResourceKey<Level> dim) {
        String loc = dim.location().getNamespace();
        String path = dim.location().getPath();
        int i = 0;
        int j = 0;
        while (i < loc.length() || j < path.length()) {
            char c = i >= loc.length() ? path.charAt(j++) : (j >= path.length() ? loc.charAt(i++) : ((i + j) % 2 == 0 ? path.charAt(j++) : loc.charAt(i++)));
            base += 55555L * (long)c * (long)(i + j);
        }
        return base;
    }

    private static int getColor(long seed) {
        RANDOM.setSeed(seed);
        return MultiverseColorHelper.getColor(RANDOM);
    }

    private static void shift(int[] color, Random rand) {
        int i = rand.nextInt(color.length);
        int n = color[i] < 128 ? 0 : 255;
        color[i] = n;
    }
}

