/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client.particles;

import io.github.davidqf555.minecraft.multiverse.client.ClientConfigs;
import io.github.davidqf555.minecraft.multiverse.registration.ParticleTypeRegistry;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;

public class RiftExplosionSeedParticle
extends NoRenderParticle {
    private static final int LIFETIME = 8;
    private final double red;
    private final double green;
    private final double blue;

    protected RiftExplosionSeedParticle(ClientLevel pLevel, double pX, double pY, double pZ, double red, double green, double blue) {
        super(pLevel, pX, pY, pZ, 0.0, 0.0, 0.0);
        this.hasPhysics = false;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.lifetime = 8;
    }

    protected int getLightColor(float pPartialTick) {
        return 0xF000F0;
    }

    public void tick() {
        super.tick();
        double range = (Double)ClientConfigs.INSTANCE.riftExplosionParticleRange.get();
        for (int i = 0; i < (Integer)ClientConfigs.INSTANCE.riftExplosionParticles.get(); ++i) {
            double pX = this.x + (this.random.nextDouble() - this.random.nextDouble()) * range;
            double pY = this.y + (this.random.nextDouble() - this.random.nextDouble()) * range;
            double pZ = this.z + (this.random.nextDouble() - this.random.nextDouble()) * range;
            this.level.addParticle((ParticleOptions)ParticleTypeRegistry.RIFT_EXPLOSION.get(), pX, pY, pZ, this.red, this.green, this.blue);
        }
    }

    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new RiftExplosionSeedParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        }
    }
}

