/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.client.render;

import io.github.davidqf555.minecraft.multiverse.common.world.entities.DoppelgangerEntity;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.layers.SpinAttackEffectLayer;
import net.minecraft.client.renderer.entity.layers.WingsLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;

public class DoppelgangerRenderer
extends HumanoidMobRenderer<DoppelgangerEntity, PlayerRenderState, PlayerModel> {
    public DoppelgangerRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new PlayerModel(context.bakeLayer(ModelLayers.PLAYER), false), 0.5f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR)), new HumanoidModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR)), context.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this));
        this.addLayer((RenderLayer)new ArrowLayer((LivingEntityRenderer)this, context));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new WingsLayer((RenderLayerParent)this, context.getModelSet(), context.getEquipmentRenderer()));
        this.addLayer((RenderLayer)new SpinAttackEffectLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer((RenderLayer)new BeeStingerLayer((LivingEntityRenderer)this, context));
    }

    @Nonnull
    public PlayerRenderState createRenderState() {
        return new PlayerRenderState();
    }

    public ResourceLocation getTextureLocation(PlayerRenderState state) {
        return state.skin.texture();
    }

    public void extractRenderState(DoppelgangerEntity entity, PlayerRenderState state, float partial) {
        PlayerInfo info;
        super.extractRenderState((Mob)entity, (HumanoidRenderState)state, partial);
        UUID id = entity.getOriginalId();
        if (id != null && (info = Minecraft.getInstance().getConnection().getPlayerInfo(id)) != null) {
            state.skin = info.getSkin();
            return;
        }
        state.skin = DefaultPlayerSkin.getDefaultSkin();
        state.arrowCount = entity.getArrowCount();
        state.stingerCount = entity.getStingerCount();
    }
}

