/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.world.DimensionHelper;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;

public final class MultiverseCommand {
    private static final String OUT_OF_BOUNDS = Util.makeDescriptionId((String)"command", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"multiverse", (String)"multiverse.out_of_bounds"));

    private MultiverseCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"multiverse").requires(source -> source.hasPermission(2))).then(Commands.argument((String)"index", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> MultiverseCommand.teleport((CommandSourceStack)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"index")))));
    }

    private static int teleport(CommandSourceStack stack, int index) throws CommandSyntaxException {
        Entity entity = stack.getEntityOrException();
        ServerLevel world = stack.getServer().getLevel(DimensionHelper.getRegistryKey(index));
        if (world == null) {
            stack.sendFailure((Component)Component.translatable((String)OUT_OF_BOUNDS, (Object[])new Object[]{index, ServerConfigs.INSTANCE.maxDimensions.get()}));
            return 0;
        }
        Vec3 pos = DimensionHelper.translate(entity.position(), entity.level().dimensionType(), world.dimensionType(), true);
        world.getChunkAt(BlockPos.containing((Position)pos));
        entity.teleport(new TeleportTransition(world, pos, Vec3.ZERO, entity.getYRot(), entity.getXRot(), TeleportTransition.DO_NOTHING));
        return 1;
    }
}

