/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.events;

import com.mojang.serialization.Lifecycle;
import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.packets.RiftParticlesPacket;
import io.github.davidqf555.minecraft.multiverse.common.world.ArrowSummonsData;
import io.github.davidqf555.minecraft.multiverse.common.world.DimensionHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.ShapesManager;
import io.github.davidqf555.minecraft.multiverse.common.world.worldgen.providers.ShapeDimensionProvider;
import io.github.davidqf555.minecraft.multiverse.registration.AttachmentTypeRegistry;
import java.util.Optional;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="multiverse", bus=EventBusSubscriber.Bus.GAME)
public final class ForgeBus {
    private ForgeBus() {
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        MinecraftServer server = event.getServer();
        ShapesManager.INSTANCE.load(server);
        RegistryAccess.Frozen composite = server.registries().compositeAccess();
        MappedRegistry registry = (MappedRegistry)composite.lookupOrThrow(Registries.LEVEL_STEM);
        registry.unfreeze(true);
        long seed = server.getWorldData().worldGenOptions().seed();
        for (int i = 1; i <= (Integer)ServerConfigs.INSTANCE.maxDimensions.get(); ++i) {
            ResourceKey key = ResourceKey.create((ResourceKey)Registries.LEVEL_STEM, (ResourceLocation)DimensionHelper.getResourceLocation(i));
            if (registry.containsKey(key)) continue;
            registry.register(key, (Object)ShapeDimensionProvider.INSTANCE.createDimension((RegistryAccess)server.registryAccess(), seed, i), new RegistrationInfo(Optional.empty(), Lifecycle.experimental()));
        }
        registry.freeze();
    }

    @SubscribeEvent
    public static void onLevelTick(LevelTickEvent.Pre event) {
        Level level = event.getLevel();
        if (!level.isClientSide()) {
            ArrowSummonsData.get((ServerLevel)level).ifPresent(data -> data.tick((ServerLevel)level));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (!event.isCanceled() && entity instanceof Mob && !entity.level().isClientSide() && ((Boolean)entity.getData(AttachmentTypeRegistry.SUMMONED)).booleanValue()) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new RiftParticlesPacket(Optional.empty(), entity.getEyePosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            entity.discard();
        }
    }
}

