/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.util;

import com.google.common.base.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;

public class IntRange {
    public static final Codec<IntRange> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("min").forGetter(IntRange::getMin), (App)Codec.INT.fieldOf("max").forGetter(IntRange::getMax)).apply((Applicative)inst, IntRange::of)).flatComapMap((Function)Functions.identity(), range -> {
        if (range.getMin() > range.getMax()) {
            return DataResult.error(() -> "Minimum cannot be greater than maximum");
        }
        return DataResult.success((Object)range);
    });
    public static final Codec<IntRange> POSITIVE_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("min").forGetter(IntRange::getMin), (App)ExtraCodecs.POSITIVE_INT.fieldOf("max").forGetter(IntRange::getMax)).apply((Applicative)inst, IntRange::of)).flatComapMap((Function)Functions.identity(), range -> {
        if (range.getMin() > range.getMax()) {
            return DataResult.error(() -> "Minimum cannot be greater than maximum");
        }
        return DataResult.success((Object)range);
    });
    private final int min;
    private final int max;

    protected IntRange(int min, int max) {
        this.min = min;
        this.max = max;
        if (min > max) {
            throw new IllegalArgumentException("Minimum cannot be greater than maximum");
        }
    }

    public static IntRange of(int min, int max) {
        return new IntRange(min, max);
    }

    public int getRandom(RandomSource random) {
        return this.getMin() + random.nextInt(this.getMax() - this.getMin() + 1);
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }
}

