/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world;

import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.packets.RiftParticlesPacket;
import io.github.davidqf555.minecraft.multiverse.common.util.TagUtil;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;

public class ArrowSummonsData
extends SavedData {
    private static final String NAME = "multiverse_ArrowSummons";
    private final Map<ShotData, Integer> data = new HashMap<ShotData, Integer>();

    protected ArrowSummonsData(CompoundTag tag, HolderLookup.Provider provider) {
        if (tag.contains("Data", 9)) {
            for (Tag t : tag.getList("Data", 10)) {
                if (!((CompoundTag)t).contains("Data", 10) || !((CompoundTag)t).contains("Count", 3)) continue;
                ShotData shot = new ShotData(Vec3.ZERO, Vec3.ZERO, null, false);
                shot.deserializeNBT(provider, ((CompoundTag)t).getCompound("Data"));
                this.data.put(shot, ((CompoundTag)t).getInt("Count"));
            }
        }
    }

    protected ArrowSummonsData() {
    }

    public static Optional<ArrowSummonsData> get(ServerLevel level) {
        return Optional.ofNullable((ArrowSummonsData)level.getDataStorage().get(new SavedData.Factory(ArrowSummonsData::new, ArrowSummonsData::new, DataFixTypes.LEVEL), NAME));
    }

    public static ArrowSummonsData getOrCreate(ServerLevel level) {
        return (ArrowSummonsData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(ArrowSummonsData::new, ArrowSummonsData::new, DataFixTypes.LEVEL), NAME);
    }

    public void tick(ServerLevel level) {
        Iterator<ShotData> iterator = this.data.keySet().iterator();
        while (iterator.hasNext()) {
            ShotData data = iterator.next();
            int count = this.data.get(data);
            if (count <= 0) {
                iterator.remove();
                continue;
            }
            if (level.getGameTime() % (long)((Integer)ServerConfigs.INSTANCE.spawnPeriod.get()).intValue() != 0L) continue;
            Entity shooter = level.getEntity(data.shooter);
            if (shooter instanceof LivingEntity && !shooter.isRemoved()) {
                this.shoot(level, (LivingEntity)shooter, data.start, data.direction, data.fireworksOnly);
                this.data.put(data, count - 1);
                continue;
            }
            iterator.remove();
        }
    }

    protected void addParticles(ServerLevel world, Vec3 start) {
        PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)world, (ChunkPos)new ChunkPos(BlockPos.containing((Position)start)), (CustomPacketPayload)new RiftParticlesPacket(Optional.empty(), start), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected ItemStack randomFirework(RandomSource random) {
        ItemStack stack = Items.FIREWORK_ROCKET.getDefaultInstance();
        int flight = random.nextInt(1, 4);
        ArrayList<FireworkExplosion> explosions = new ArrayList<FireworkExplosion>();
        DyeColor[] options = DyeColor.values();
        int count = random.nextInt(1, 5);
        for (int i = 0; i < count; ++i) {
            FireworkExplosion.Shape shape = (FireworkExplosion.Shape)Util.getRandom((Object[])FireworkExplosion.Shape.values(), (RandomSource)random);
            boolean flicker = random.nextBoolean();
            boolean trail = random.nextBoolean();
            int[] colors = new int[random.nextInt(1, 9)];
            for (int j = 0; j < colors.length; ++j) {
                colors[j] = options[random.nextInt(options.length)].getFireworkColor();
            }
            explosions.add(new FireworkExplosion(shape, IntList.of((int[])colors), IntList.of(), trail, flicker));
        }
        stack.set(DataComponents.FIREWORKS, (Object)new Fireworks(flight, explosions));
        return stack;
    }

    protected AbstractArrow randomArrow(ServerLevel world, LivingEntity shooter) {
        RandomSource random = world.getRandom();
        ArrowItem item = (ArrowItem)BuiltInRegistries.ITEM.get(ItemTags.ARROWS).map(tag -> tag.getRandomElement(random)).filter(Optional::isPresent).map(Optional::get).map(Holder::value).filter(i -> i instanceof ArrowItem).orElse(Items.ARROW);
        ItemStack stack = item.getDefaultInstance();
        if (item == Items.TIPPED_ARROW) {
            PotionContents potion = BuiltInRegistries.POTION.getRandom(random).map(PotionContents::new).orElse(PotionContents.EMPTY);
            stack.set(DataComponents.POTION_CONTENTS, (Object)potion);
        }
        ItemStack bow = (random.nextBoolean() ? Items.CROSSBOW : Items.BOW).getDefaultInstance();
        ItemEnchantments.Mutable enchantments = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        for (ResourceKey key : List.of(Enchantments.PUNCH, Enchantments.PIERCING, Enchantments.POWER)) {
            Holder holder = world.holderOrThrow(key);
            int max = ((Enchantment)holder.value()).getMaxLevel();
            enchantments.set(holder, random.nextInt(max + 1));
        }
        if (random.nextDouble() < (Double)ServerConfigs.INSTANCE.fireRate.get()) {
            enchantments.set(world.holderOrThrow(Enchantments.FLAME), 1);
        }
        EnchantmentHelper.setEnchantments((ItemStack)bow, (ItemEnchantments)enchantments.toImmutable());
        AbstractArrow arrow = item.createArrow((Level)world, stack, shooter, bow);
        arrow.setCritArrow(true);
        return arrow;
    }

    public void add(Vec3 start, Vec3 direction, UUID shooter, int count, boolean fireworksOnly) {
        this.data.put(new ShotData(start, direction, shooter, fireworksOnly), count);
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        this.data.forEach((data, count) -> {
            CompoundTag t = new CompoundTag();
            t.put("Data", (Tag)data.serializeNBT(provider));
            t.putInt("Count", count.intValue());
            list.add((Object)t);
        });
        tag.put("Data", (Tag)list);
        return tag;
    }

    @Nullable
    protected Vec3 getStartPosition(ServerLevel world, Vec3 center, Vec3 direction) {
        RandomSource random = world.getRandom();
        double min = (Double)ServerConfigs.INSTANCE.minSpawnRadius.get();
        double max = (Double)ServerConfigs.INSTANCE.maxSpawnRadius.get();
        double offset = (Double)ServerConfigs.INSTANCE.spawnOffset.get();
        Vec3 start = direction.cross(new Vec3(0.0, 1.0, 0.0));
        start = start.lengthSqr() < 1.0E-8 ? new Vec3(1.0, 0.0, 0.0) : start.normalize();
        Vec3 parallel = direction.scale(direction.dot(start));
        Vec3 perp = start.subtract(parallel);
        Vec3 cross = direction.cross(perp).normalize();
        for (int i = 0; i < 16; ++i) {
            double dist = random.nextDouble() * (max - min) + min;
            float angle = random.nextFloat() * ((float)Math.PI * 2);
            Vec3 rotate = perp.scale((double)Mth.cos((float)angle)).add(cross.scale((double)Mth.sin((float)angle) * perp.length()));
            Vec3 pos = center.add(rotate.add(parallel).scale(dist)).add(direction.scale(offset));
            BlockPos block = BlockPos.containing((Position)pos);
            if (world.getBlockState(block).isSolidRender()) continue;
            return pos;
        }
        return null;
    }

    private void shoot(ServerLevel world, LivingEntity shooter, Vec3 center, Vec3 direction, boolean fireworksOnly) {
        if (!world.isClientSide()) {
            direction = direction.normalize();
            RandomSource rand = world.getRandom();
            Vec3 start = this.getStartPosition(world, center, direction);
            if (start != null) {
                AbstractArrow projectile;
                if (fireworksOnly || rand.nextDouble() < (Double)ServerConfigs.INSTANCE.fireworkRate.get()) {
                    projectile = new FireworkRocketEntity((Level)world, this.randomFirework(rand), (Entity)shooter, start.x(), start.y(), start.z(), true);
                } else {
                    projectile = this.randomArrow(world, shooter);
                    projectile.setPos(start);
                    projectile.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                }
                float multiplier = rand.nextFloat() * 2.0f + 1.5f;
                float variation = rand.nextFloat() * 0.4f + 0.8f;
                projectile.shoot(direction.x(), direction.y(), direction.z(), multiplier, variation);
                world.addFreshEntity((Entity)projectile);
                this.addParticles(world, start);
                world.playSound(null, start.x(), start.y(), start.z(), SoundEvents.CROSSBOW_SHOOT, SoundSource.PLAYERS, 1.0f, rand.nextFloat() * 0.3f + 0.85f);
            }
        }
    }

    protected static class ShotData
    implements INBTSerializable<CompoundTag> {
        protected Vec3 start;
        protected Vec3 direction;
        protected UUID shooter;
        protected boolean fireworksOnly;

        protected ShotData(Vec3 start, Vec3 direction, UUID shooter, boolean fireworksOnly) {
            this.start = start;
            this.direction = direction.normalize();
            this.shooter = shooter;
            this.fireworksOnly = fireworksOnly;
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag tag = new CompoundTag();
            tag.put("Start", (Tag)TagUtil.writeVec(this.start));
            tag.put("Direction", (Tag)TagUtil.writeVec(this.direction));
            tag.putBoolean("FireworksOnly", this.fireworksOnly);
            tag.putUUID("Shooter", this.shooter);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            Vec3 dir;
            Vec3 start;
            if (nbt.contains("Start", 10) && (start = TagUtil.readVec(nbt.getCompound("Start"))) != null) {
                this.start = start;
            }
            if (nbt.contains("Direction", 10) && (dir = TagUtil.readVec(nbt.getCompound("Direction"))) != null) {
                this.direction = dir;
            }
            if (nbt.contains("Shooter", 11)) {
                this.shooter = nbt.getUUID("Shooter");
            }
            if (nbt.contains("FireworksOnly", 1)) {
                this.fireworksOnly = nbt.getBoolean("FireworksOnly");
            }
        }
    }
}

