/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world;

import io.github.davidqf555.minecraft.multiverse.common.packets.RiftParticlesPacket;
import io.github.davidqf555.minecraft.multiverse.common.world.DimensionHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.RiftHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public final class WarpTeleporter {
    private static final TeleportTransition.PostTeleportTransition POST = RiftHelper.SLOW_FALLING.then(RiftHelper.CLEAR).then(TeleportTransition.PLAY_PORTAL_SOUND);

    private WarpTeleporter() {
    }

    @Nullable
    public static Entity warp(Entity entity, ResourceKey<Level> target) {
        Entity copy;
        if (entity.level().isClientSide()) {
            return null;
        }
        ResourceKey current = entity.level().dimension();
        if (target.equals((Object)current)) {
            return null;
        }
        ServerLevel world = entity.getServer().getLevel(target);
        if (world == null || !entity.canTeleport(entity.level(), (Level)world)) {
            return null;
        }
        Level from = entity.level();
        Vec3 pos = entity.getEyePosition();
        if (entity.canTeleport(from, (Level)world) && (copy = entity.teleport(WarpTeleporter.getPortalDestination(world, entity, entity.blockPosition()))) != null) {
            PacketDistributor.sendToPlayersTrackingChunk((ServerLevel)((ServerLevel)from), (ChunkPos)new ChunkPos(BlockPos.containing((Position)pos)), (CustomPacketPayload)new RiftParticlesPacket(Optional.of(target), pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
            from.playSound(null, pos.x(), pos.y(), pos.z(), SoundEvents.ENDERMAN_TELEPORT, copy.getSoundSource(), 1.0f, 1.0f);
            Vec3 changed = copy.getEyePosition();
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)copy, (CustomPacketPayload)new RiftParticlesPacket(Optional.of(current), changed), (CustomPacketPayload[])new CustomPacketPayload[0]);
            world.playSound(null, changed.x(), changed.y(), changed.z(), SoundEvents.ENDERMAN_TELEPORT, copy.getSoundSource(), 1.0f, 1.0f);
            return copy;
        }
        return null;
    }

    public static TeleportTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        DimensionType target = level.dimensionType();
        DimensionType from = entity.level().dimensionType();
        Vec3 scaled = DimensionHelper.translate(Vec3.atCenterOf((Vec3i)pos), from, target, true);
        if (scaled.y() <= (double)target.minY()) {
            scaled = new Vec3(scaled.x(), (double)(target.minY() + 1), scaled.z());
        }
        WorldBorder border = level.getWorldBorder();
        BlockPos clamped = border.clampToBounds(scaled.x(), scaled.y(), scaled.z());
        Vec3 to = Vec3.atBottomCenterOf((Vec3i)clamped);
        return new TeleportTransition(level, to, Vec3.ZERO, entity.getYRot(), entity.getXRot(), POST);
    }
}

