/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.blocks;

import com.mojang.serialization.MapCodec;
import io.github.davidqf555.minecraft.multiverse.common.MultiverseTags;
import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.world.DimensionHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.RiftHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.RiftPlacementHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.blocks.RiftTileEntity;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.EntityHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.TravelerEntity;
import io.github.davidqf555.minecraft.multiverse.registration.EntityRegistry;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
public class RiftBlock
extends BaseEntityBlock
implements BucketPickup,
LiquidBlockContainer,
Portal {
    private static final TeleportTransition.PostTeleportTransition POST = RiftHelper.SLOW_FALLING.then(RiftHelper.TRIGGER).then(TeleportTransition.PLAY_PORTAL_SOUND);
    public static final MapCodec<RiftBlock> CODEC = RiftBlock.simpleCodec(RiftBlock::new);
    public static final BooleanProperty TEMPORARY = BooleanProperty.create((String)"temporary");
    public static final EnumProperty<LoggedFluid> FLUID = EnumProperty.create((String)"fluid", LoggedFluid.class, (Enum[])LoggedFluid.values());

    public RiftBlock(BlockBehaviour.Properties properties) {
        super(properties.noCollission().randomTicks());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)TEMPORARY, (Comparable)Boolean.valueOf(true))).setValue(FLUID, (Comparable)((Object)LoggedFluid.AIR)));
    }

    protected MapCodec<? extends RiftBlock> codec() {
        return CODEC;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        if (rand.nextDouble() < 0.01) {
            world.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.PORTAL_AMBIENT, SoundSource.BLOCKS, 0.5f, rand.nextFloat() * 0.4f + 0.8f, false);
        }
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return Shapes.empty();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new RiftTileEntity(pos, state);
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        TravelerEntity entity;
        if (((Boolean)state.getValue((Property)TEMPORARY)).booleanValue()) {
            world.destroyBlock(pos, true);
        } else if (rand.nextDouble() < (Double)ServerConfigs.INSTANCE.travelerSpawnChance.get() && (entity = (TravelerEntity)((Object)EntityHelper.randomSpawn((EntityType)EntityRegistry.TRAVELER.get(), world, pos, 0, 8, EntitySpawnReason.NATURAL))) != null) {
            entity.setPortalCooldown();
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TEMPORARY, FLUID});
    }

    public boolean canBeReplaced(BlockState state, Fluid fluid) {
        return false;
    }

    protected void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (world instanceof ServerLevel && tile instanceof RiftTileEntity && entity.canUsePortal(false) && !entity.getType().is(MultiverseTags.IGNORE_RIFT) && ((RiftTileEntity)tile).isColliding(entity.getBoundingBox())) {
            entity.setAsInsidePortal((Portal)this, pos);
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        LoggedFluid fluid = LoggedFluid.AIR;
        Fluid type = world.getFluidState(pos).getType();
        if (type == Fluids.WATER) {
            fluid = LoggedFluid.WATER;
        } else if (type == Fluids.LAVA) {
            fluid = LoggedFluid.LAVA;
        }
        return (BlockState)this.defaultBlockState().setValue(FLUID, (Comparable)((Object)fluid));
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tick, BlockPos pos, Direction dir, BlockPos update, BlockState next, RandomSource random) {
        LoggedFluid fluid = (LoggedFluid)((Object)state.getValue(FLUID));
        if (fluid != LoggedFluid.AIR) {
            tick.scheduleTick(pos, fluid.getFluid(), fluid.getFluid().getTickDelay(world));
        }
        return super.updateShape(state, world, tick, pos, dir, update, next, random);
    }

    public FluidState getFluidState(BlockState state) {
        return ((LoggedFluid)((Object)state.getValue(FLUID))).getState();
    }

    public ItemStack pickupBlock(@Nullable Player player, LevelAccessor world, BlockPos pos, BlockState state) {
        return switch (((LoggedFluid)((Object)state.getValue(FLUID))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ItemStack.EMPTY;
            case 1 -> {
                world.setBlock(pos, (BlockState)state.setValue(FLUID, (Comparable)((Object)LoggedFluid.AIR)), 3);
                yield new ItemStack((ItemLike)Items.WATER_BUCKET);
            }
            case 2 -> {
                world.setBlock(pos, (BlockState)state.setValue(FLUID, (Comparable)((Object)LoggedFluid.AIR)), 3);
                yield new ItemStack((ItemLike)Items.LAVA_BUCKET);
            }
        };
    }

    public Optional<SoundEvent> getPickupSound() {
        return Fluids.WATER.getPickupSound();
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter getter, BlockPos pos, BlockState state, Fluid fluid) {
        return state.getValue(FLUID) == LoggedFluid.AIR && (fluid == Fluids.WATER || fluid == Fluids.LAVA);
    }

    public boolean placeLiquid(LevelAccessor world, BlockPos pos, BlockState block, FluidState fluid) {
        if (block.getValue(FLUID) == LoggedFluid.AIR) {
            if (!world.isClientSide()) {
                if (fluid.getType() == Fluids.WATER) {
                    world.setBlock(pos, (BlockState)block.setValue(FLUID, (Comparable)((Object)LoggedFluid.WATER)), 3);
                    world.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)world));
                } else if (fluid.getType() == Fluids.LAVA) {
                    world.setBlock(pos, (BlockState)block.setValue(FLUID, (Comparable)((Object)LoggedFluid.LAVA)), 3);
                    world.scheduleTick(pos, (Fluid)Fluids.LAVA, Fluids.LAVA.getTickDelay((LevelReader)world));
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    public TeleportTransition getPortalDestination(ServerLevel level, Entity entity, BlockPos pos) {
        ServerLevel target;
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof RiftTileEntity && (target = level.getServer().getLevel(((RiftTileEntity)be).getTarget())) != null) {
            Vec3 scaled = DimensionHelper.translate(Vec3.atCenterOf((Vec3i)pos), level.dimensionType(), target.dimensionType(), true);
            WorldBorder border = target.getWorldBorder();
            BlockPos clamped = border.clampToBounds(scaled.x(), scaled.y(), scaled.z());
            Vec3 loc = RiftHelper.getOrCreateRift(target, (ResourceKey<Level>)level.dimension(), Vec3.atCenterOf((Vec3i)clamped), (Boolean)level.getBlockState(pos).getValue((Property)TEMPORARY), (Integer)ServerConfigs.INSTANCE.riftRange.get(), RiftPlacementHelper.ReplacementType.DESTROY);
            return new TeleportTransition(target, loc, entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), POST);
        }
        return null;
    }

    public static enum LoggedFluid implements StringRepresentable
    {
        AIR("air", Fluids.EMPTY.defaultFluidState()),
        WATER("water", Fluids.WATER.getSource(false)),
        LAVA("lava", Fluids.LAVA.getSource(false));

        private final String name;
        private final Fluid fluid;
        private final FluidState state;

        private LoggedFluid(String name, FluidState state) {
            this.name = name;
            this.state = state;
            this.fluid = state.getType();
        }

        public String getSerializedName() {
            return this.name;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public FluidState getState() {
            return this.state;
        }
    }
}

