/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.blocks;

import io.github.davidqf555.minecraft.multiverse.common.util.TagUtil;
import io.github.davidqf555.minecraft.multiverse.common.world.RiftPlacementHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.blocks.RiftPlacement;
import io.github.davidqf555.minecraft.multiverse.registration.TileEntityRegistry;
import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RiftTileEntity
extends BlockEntity {
    private static final RiftPlacement DEFAULT = new RiftPlacement(new Vec3(0.0, 0.0, 0.0), 0.0, 0.0, new Vec3(0.0, 1.0, 0.0), 0.0f);
    private ResourceKey<Level> target = Level.OVERWORLD;
    private Vec3[][] collision = new Vec3[2][0];
    private RiftPlacement parent = DEFAULT;
    private Vec3[][] visual;

    protected RiftTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public RiftTileEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TileEntityRegistry.RIFT.get(), pos, state);
    }

    protected static Vec3[][] convert(Vec3[] vertices) {
        if (vertices.length < 2) {
            return new Vec3[2][0];
        }
        Vec3[][] all = new Vec3[2][vertices.length];
        System.arraycopy(vertices, 0, all[0], 0, vertices.length);
        all[1][all.length - 1] = all[0][0];
        System.arraycopy(all[0], 1, all[1], 0, all.length - 1);
        return all;
    }

    public ResourceKey<Level> getTarget() {
        return this.target;
    }

    public void setTarget(ResourceKey<Level> target) {
        this.target = target;
    }

    public Vec3 getNormal() {
        return this.getParent().normal();
    }

    public Vec3[][] getCollision() {
        return this.collision;
    }

    public void setCollision(Vec3[] collision) {
        this.collision = RiftTileEntity.convert(collision);
    }

    public RiftPlacement getParent() {
        return this.parent;
    }

    public void setParent(RiftPlacement parent) {
        this.parent = parent;
        this.visual = null;
    }

    public Vec3[][] getVisual() {
        if (this.visual == null) {
            RiftPlacement parent = this.getParent();
            this.visual = parent.calculateLayers(BlockPos.ZERO);
        }
        return this.visual;
    }

    public boolean isColliding(AABB bounds) {
        return RiftPlacementHelper.intersects(this.getCollision(), this.getNormal(), bounds);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putString("Target", this.getTarget().location().toString());
        Vec3 offset = Vec3.atLowerCornerOf((Vec3i)this.getBlockPos());
        ListTag collision = new ListTag();
        for (Vec3 point : this.getCollision()[0]) {
            collision.add((Object)TagUtil.writeVec(point.subtract(offset)));
        }
        tag.put("Vertices", (Tag)collision);
        CompoundTag parent = this.getParent().serialize();
        tag.put("Parent", (Tag)parent);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        RiftPlacement placement;
        super.loadAdditional(tag, provider);
        if (tag.contains("Target", 8)) {
            this.setTarget((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)tag.getString("Target"))));
        }
        if (tag.contains("Vertices", 9)) {
            Vec3 offset = Vec3.atLowerCornerOf((Vec3i)this.getBlockPos());
            ListTag list = tag.getList("Vertices", 10);
            ArrayList<Vec3> vertices = new ArrayList<Vec3>();
            for (Tag val : list) {
                Vec3 point = TagUtil.readVec((CompoundTag)val);
                if (point == null) continue;
                vertices.add(point.add(offset));
            }
            this.setCollision((Vec3[])vertices.toArray(Vec3[]::new));
        }
        if (tag.contains("Parent", 10) && (placement = RiftPlacement.deserialize(tag.getCompound("Parent"))) != null) {
            this.setParent(placement);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

