/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.effects;

import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.world.RiftHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ConquerorEntity;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.EntityHelper;
import io.github.davidqf555.minecraft.multiverse.registration.EntityRegistry;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ConquerorEffect
extends MobEffect {
    public ConquerorEffect(MobEffectCategory pCategory, int pColor) {
        super(pCategory, pColor);
    }

    public boolean applyEffectTick(ServerLevel world, LivingEntity pLivingEntity, int pAmplifier) {
        if (pLivingEntity instanceof ServerPlayer && !pLivingEntity.isSpectator()) {
            Raid raid;
            ConquerorEntity entity;
            if (world.getDifficulty() == Difficulty.PEACEFUL) {
                return true;
            }
            if (world.isVillage(pLivingEntity.blockPosition()) && (entity = (ConquerorEntity)((EntityType)EntityRegistry.CONQUEROR.get()).create((Level)world, EntitySpawnReason.EVENT)) != null && (raid = world.getRaids().createOrExtendRaid((ServerPlayer)pLivingEntity, pLivingEntity.blockPosition())) != null) {
                Vec3 pos = EntityHelper.getRandomSpawnAbove(world, pLivingEntity.getRandom(), Vec3.atBottomCenterOf((Vec3i)raid.getCenter()), (Double)ServerConfigs.INSTANCE.conquerorMaxSpawnHDist.get(), (Double)ServerConfigs.INSTANCE.conquerorMinSpawnDist.get(), (Double)ServerConfigs.INSTANCE.conquerorMaxSpawnDist.get(), Set.of((EntityType)EntityRegistry.CONQUEROR.get()));
                entity.setPortalCooldown();
                RiftHelper.placeRandomRift(world, false, pos, true);
                raid.joinRaid(raid.getGroupsSpawned(), (Raider)entity, BlockPos.containing((Position)pos), false);
                raid.setLeader(raid.getGroupsSpawned(), (Raider)entity);
                return false;
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }
}

