/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.entities;

import com.mojang.datafixers.util.Pair;
import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.world.PublicRaidType;
import io.github.davidqf555.minecraft.multiverse.common.world.RiftHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.EntityHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ai.FlyingMoveThroughVillageGoal;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ai.FlyingPathfindToRaidGoal;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ai.NoGravityNavigator;
import io.github.davidqf555.minecraft.multiverse.common.world.items.MultiversalAxeItem;
import io.github.davidqf555.minecraft.multiverse.registration.AttachmentTypeRegistry;
import io.github.davidqf555.minecraft.multiverse.registration.ItemRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ConquerorEntity
extends SpellcasterIllager {
    private final ServerBossEvent bar = new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public ConquerorEntity(EntityType<? extends ConquerorEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
        this.setPathfindingMalus(PathType.LAVA, 8.0f);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 0.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, 0.0f);
        this.setItemInHand(InteractionHand.MAIN_HAND, ((MultiversalAxeItem)((Object)ItemRegistry.PRISMATIC_AXE.get())).getDefaultInstance());
        this.xpReward = 50;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ConquerorEntity.createMonsterAttributes().add(Attributes.MAX_HEALTH, 200.0).add(Attributes.FLYING_SPEED, 0.2).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ARMOR, 11.0).add(Attributes.FOLLOW_RANGE, 64.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.ATTACK_KNOCKBACK, 5.0).add(Attributes.KNOCKBACK_RESISTANCE, 1.0).add(Attributes.GRAVITY, 0.0);
    }

    protected float getFlyingSpeed() {
        return this.getSpeed();
    }

    public AbstractIllager.IllagerArmPose getArmPose() {
        if (this.isCastingSpell()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        if (this.isAggressive()) {
            return AbstractIllager.IllagerArmPose.ATTACKING;
        }
        return this.isCelebrating() ? AbstractIllager.IllagerArmPose.CELEBRATING : AbstractIllager.IllagerArmPose.NEUTRAL;
    }

    protected void customServerAiStep(ServerLevel world) {
        super.customServerAiStep(world);
        this.bar.setProgress(this.getHealth() / this.getMaxHealth());
    }

    public void setCustomName(@javax.annotation.Nullable Component name) {
        super.setCustomName(name);
        this.bar.setName(this.getDisplayName());
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        this.bar.addPlayer(player);
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        this.bar.removePlayer(player);
    }

    protected PathNavigation createNavigation(Level pLevel) {
        NoGravityNavigator navigator = new NoGravityNavigator((Mob)this, pLevel);
        navigator.setCanFloat(true);
        return navigator;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(4, (Goal)new PatrollingMonster.LongDistancePatrolGoal((PatrollingMonster)this, 0.7, 0.595));
        this.goalSelector.addGoal(3, (Goal)new Raider.ObtainRaidLeaderBannerGoal((Raider)this, (Raider)this));
        this.goalSelector.addGoal(3, (Goal)new FlyingPathfindToRaidGoal((Raider)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new FlyingMoveThroughVillageGoal((Raider)this, 1.05, 1));
        this.goalSelector.addGoal(5, (Goal)new Raider.RaiderCelebration((Raider)this, (Raider)this));
        this.goalSelector.addGoal(0, (Goal)new SpellcasterIllager.SpellcasterCastingSpellGoal((SpellcasterIllager)this));
        this.goalSelector.addGoal(1, (Goal)new SpawnRiftGoal());
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 2.0, false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).setUnseenMemoryTicks(300));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public boolean isInvulnerableTo(ServerLevel world, DamageSource pSource) {
        return super.isInvulnerableTo(world, pSource) || pSource.is(DamageTypeTags.IS_FIRE) || pSource.is(DamageTypeTags.IS_DROWNING);
    }

    protected SoundEvent getCastingSoundEvent() {
        return SoundEvents.EVOKER_CAST_SPELL;
    }

    public void applyRaidBuffs(ServerLevel level, int wave, boolean unused) {
    }

    public SoundEvent getCelebrateSound() {
        return SoundEvents.EVOKER_CELEBRATE;
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        if (this.hasCustomName()) {
            this.bar.setName(this.getDisplayName());
        }
    }

    public class SpawnRiftGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public SpawnRiftGoal() {
            super((SpellcasterIllager)ConquerorEntity.this);
        }

        public boolean canUse() {
            LivingEntity target = ConquerorEntity.this.getTarget();
            if (!super.canUse()) {
                return false;
            }
            if (target == null) {
                if (!ConquerorEntity.this.hasActiveRaid()) {
                    return false;
                }
                return ConquerorEntity.this.getCurrentRaid().getTotalRaidersAlive() < (Integer)ServerConfigs.INSTANCE.conquerorMobThreshold.get();
            }
            if (target.distanceToSqr(ConquerorEntity.this.position()) > (Double)ServerConfigs.INSTANCE.conquerorDistanceThreshold.get() * (Double)ServerConfigs.INSTANCE.conquerorDistanceThreshold.get()) {
                double range = ConquerorEntity.this.getAttributeValue(Attributes.FOLLOW_RANGE);
                AABB bounds = AABB.ofSize((Vec3)ConquerorEntity.this.getEyePosition(), (double)(range * 2.0), (double)(range * 2.0), (double)(range * 2.0));
                return ConquerorEntity.this.level().getEntitiesOfClass(Raider.class, bounds).size() < (Integer)ServerConfigs.INSTANCE.conquerorMobThreshold.get();
            }
            return false;
        }

        protected void performSpellCasting() {
            HashMap<EntityType, Integer> entities = new HashMap<EntityType, Integer>();
            for (int i = 0; i < (Integer)ServerConfigs.INSTANCE.conquerorSpawnCount.get(); ++i) {
                entities.compute(this.selectEntityType(), (k, v) -> v == null ? 1 : v + 1);
            }
            Vec3 pos = this.getRiftTarget(entities.keySet());
            RiftHelper.placeRandomRift((ServerLevel)ConquerorEntity.this.level(), false, pos, true);
            BlockPos block = BlockPos.containing((Position)pos);
            entities.forEach((type, n) -> {
                Raider entity = (Raider)type.spawn((ServerLevel)ConquerorEntity.this.level(), block, EntitySpawnReason.REINFORCEMENT);
                if (entity != null) {
                    Raid raid = ConquerorEntity.this.getCurrentRaid();
                    if (Raids.canJoinRaid((Raider)entity, (Raid)raid)) {
                        raid.joinRaid(raid.getGroupsSpawned(), entity, null, true);
                    }
                    entity.setPortalCooldown();
                    if ((Integer)ServerConfigs.INSTANCE.conquerorSlowFallingAmplifier.get() > 0 && (Integer)ServerConfigs.INSTANCE.conquerorSlowFallingDuration.get() > 0) {
                        entity.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, ((Integer)ServerConfigs.INSTANCE.conquerorSlowFallingDuration.get()).intValue(), (Integer)ServerConfigs.INSTANCE.conquerorSlowFallingAmplifier.get() - 1));
                    }
                    entity.setTarget(ConquerorEntity.this.getTarget());
                    entity.setData(AttachmentTypeRegistry.SUMMONED, (Object)true);
                }
            });
        }

        @Nullable
        protected EntityType<? extends Raider> selectEntityType() {
            ArrayList<Pair> weights = new ArrayList<Pair>();
            int total = 0;
            for (Raid.RaiderType type : Raid.RaiderType.values()) {
                int amt = Arrays.stream(type.spawnsPerWaveBeforeBonus).reduce(0, Integer::sum);
                weights.add(Pair.of((Object)type, (Object)amt));
                total += amt;
            }
            if (total <= 0) {
                return null;
            }
            int rand = ConquerorEntity.this.getRandom().nextInt(total);
            for (Pair pair : weights) {
                if (rand < (total -= ((Integer)pair.getSecond()).intValue())) continue;
                return ((PublicRaidType)pair.getFirst()).getEntityType();
            }
            throw new RuntimeException("should not ever get here");
        }

        protected Vec3 getRiftTarget(Set<EntityType<?>> types) {
            LivingEntity target = ConquerorEntity.this.getTarget();
            Vec3 center = target != null ? target.getEyePosition() : (ConquerorEntity.this.hasActiveRaid() ? Vec3.atCenterOf((Vec3i)ConquerorEntity.this.getCurrentRaid().getCenter()) : ConquerorEntity.this.getEyePosition());
            return EntityHelper.getRandomSpawnAbove((ServerLevel)ConquerorEntity.this.level(), ConquerorEntity.this.getRandom(), center, (Double)ServerConfigs.INSTANCE.conquerorMaxSpawnHDist.get(), (Double)ServerConfigs.INSTANCE.conquerorMinSpawnDist.get(), (Double)ServerConfigs.INSTANCE.conquerorMaxSpawnDist.get(), types);
        }

        protected int getCastingTime() {
            return (Integer)ServerConfigs.INSTANCE.conquerorCastTime.get();
        }

        protected int getCastingInterval() {
            return (Integer)ServerConfigs.INSTANCE.conquerorCooldown.get();
        }

        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.EVOKER_PREPARE_SUMMON;
        }

        protected SpellcasterIllager.IllagerSpell getSpell() {
            return SpellcasterIllager.IllagerSpell.DISAPPEAR;
        }
    }
}

