/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.entities;

import io.github.davidqf555.minecraft.multiverse.common.MultiverseTags;
import io.github.davidqf555.minecraft.multiverse.common.ServerConfigs;
import io.github.davidqf555.minecraft.multiverse.common.packets.RiftParticlesPacket;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.EntityHelper;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ai.EntityHurtByTargetGoal;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ai.EntityHurtTargetGoal;
import io.github.davidqf555.minecraft.multiverse.common.world.entities.ai.FollowEntityGoal;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class DoppelgangerEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Optional<UUID>> ORIGINAL = SynchedEntityData.defineId(DoppelgangerEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final double GEAR_RATE = 0.8;

    public DoppelgangerEntity(EntityType<? extends DoppelgangerEntity> mob, Level level) {
        super(mob, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return DoppelgangerEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 20.0).add(Attributes.ATTACK_DAMAGE, 5.0).add(Attributes.MOVEMENT_SPEED, 0.35635);
    }

    @Nullable
    public static <T extends DoppelgangerEntity> T spawnRandom(EntityType<T> type, ServerPlayer player, BlockPos center, int minOffset, int maxOffset) {
        DoppelgangerEntity entity = (DoppelgangerEntity)((Object)EntityHelper.randomSpawn(type, player.serverLevel(), center, minOffset, maxOffset, EntitySpawnReason.REINFORCEMENT));
        if (entity != null) {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new RiftParticlesPacket(Optional.empty(), entity.getEyePosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            entity.setOriginal((Player)player);
        }
        return (T)((Object)entity);
    }

    public static boolean canSpawn(EntityType<? extends DoppelgangerEntity> type, ServerLevelAccessor level, EntitySpawnReason spawn, BlockPos pos, RandomSource rand) {
        return spawn == EntitySpawnReason.REINFORCEMENT;
    }

    private static TagKey<Item> getEquipmentTag(EquipmentSlot slot) {
        return switch (slot) {
            default -> throw new MatchException(null, null);
            case EquipmentSlot.HEAD -> MultiverseTags.DOPPELGANGER_HEAD;
            case EquipmentSlot.CHEST -> MultiverseTags.DOPPELGANGER_CHEST;
            case EquipmentSlot.LEGS -> MultiverseTags.DOPPELGANGER_LEGS;
            case EquipmentSlot.FEET -> MultiverseTags.DOPPELGANGER_FEET;
            case EquipmentSlot.MAINHAND -> MultiverseTags.DOPPELGANGER_MAIN_HAND;
            case EquipmentSlot.OFFHAND -> MultiverseTags.DOPPELGANGER_OFF_HAND;
            case EquipmentSlot.BODY -> MultiverseTags.DOPPELGANGER_BODY;
        };
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, EntitySpawnReason spawn, @Nullable SpawnGroupData data) {
        this.populateDefaultEquipmentSlots(this.random, difficulty);
        this.populateDefaultEquipmentEnchantments(level, this.random, difficulty);
        return super.finalizeSpawn(level, difficulty, spawn, data);
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        Registry registry = this.level().registryAccess().lookupOrThrow(Registries.ITEM);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (!(random.nextDouble() < 0.8)) continue;
            registry.get(DoppelgangerEntity.getEquipmentTag(slot)).flatMap(tag -> tag.getRandomElement(random)).map(Holder::value).map(Item::getDefaultInstance).ifPresent(stack -> this.setItemSlot(slot, (ItemStack)stack));
        }
    }

    protected float getEquipmentDropChance(EquipmentSlot slot) {
        return 0.0f;
    }

    public boolean shouldDropExperience() {
        return false;
    }

    protected boolean shouldDropLoot() {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(2, new FollowEntityGoal<DoppelgangerEntity>(this, DoppelgangerEntity::getOriginal, 12.0, 8.0, 1.0f));
        this.goalSelector.addGoal(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, new EntityHurtByTargetGoal<DoppelgangerEntity>(this, DoppelgangerEntity::getOriginal));
        this.targetSelector.addGoal(2, new EntityHurtTargetGoal<DoppelgangerEntity>(this, DoppelgangerEntity::getOriginal));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, false, false, (entity, world) -> entity instanceof Enemy && !(entity instanceof Creeper)));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ORIGINAL, Optional.empty());
    }

    protected void customServerAiStep(ServerLevel world) {
        super.customServerAiStep(world);
        Player original = this.getOriginal();
        if (original == null) {
            this.kill(world);
        } else if (original.tickCount - Math.max(original.getLastHurtMobTimestamp(), original.getLastHurtByMobTimestamp()) >= (Integer)ServerConfigs.INSTANCE.doppelTimeout.get()) {
            this.kill(world);
        }
    }

    protected void tickDeath() {
        if (this.level().isClientSide()) {
            super.tickDeath();
        } else {
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)new RiftParticlesPacket(Optional.empty(), this.getEyePosition()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.discard();
        }
    }

    @Nullable
    public Player getOriginal() {
        UUID original = this.getOriginalId();
        if (original != null) {
            return this.level().getPlayerByUUID(original);
        }
        return null;
    }

    public void setOriginal(@Nullable Player player) {
        if (player == null) {
            this.setOriginalId(null);
            this.setCustomName(null);
            this.setCustomNameVisible(false);
        } else {
            this.setOriginalId(player.getUUID());
            this.setCustomName(player.getDisplayName());
            this.setCustomNameVisible(true);
        }
    }

    @Nullable
    public UUID getOriginalId() {
        return ((Optional)this.getEntityData().get(ORIGINAL)).orElse(null);
    }

    public void setOriginalId(@Nullable UUID id) {
        this.getEntityData().set(ORIGINAL, Optional.ofNullable(id));
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        if (tag.contains("Original", 11)) {
            this.setOriginalId(tag.getUUID("Original"));
        }
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        UUID id = this.getOriginalId();
        if (id != null) {
            tag.putUUID("Original", id);
        }
    }
}

