/*
 * Decompiled with CFR 0.152.
 */
package io.github.davidqf555.minecraft.multiverse.common.world.entities;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class EntityHelper {
    private static final int TRIES = 32;

    private EntityHelper() {
    }

    public static Vec3 getRandomSpawnAbove(ServerLevel world, RandomSource rand, Vec3 center, double max, double minY, double maxY, Set<EntityType<?>> types) {
        block0: for (int i = 0; i < 32; ++i) {
            Vec3 pos = EntityHelper.randomAroundAbove(rand, center, max, minY, maxY);
            for (EntityType<?> type : types) {
                if (EntityHelper.canSpawnPosition(world, pos, type)) continue;
                continue block0;
            }
            return pos;
        }
        return EntityHelper.randomAroundAbove(rand, center, max, minY, maxY);
    }

    public static Vec3 randomAround(RandomSource rand, Vec3 center, double min, double max) {
        double a = rand.nextDouble() * 2.0 * Math.PI;
        double b = rand.nextDouble() * Math.PI - 1.5707963267948966;
        double dist = rand.nextDouble() * (max - min) + min;
        double dX = Math.sin(a) * Math.cos(b) * dist;
        double dZ = Math.cos(a) * Math.cos(b) * dist;
        double dY = Math.sin(b) * dist;
        return center.add(dX, dY, dZ);
    }

    public static Vec3 randomAroundAbove(RandomSource rand, Vec3 center, double max, double minY, double maxY) {
        double dY = rand.nextDouble() * (maxY - minY) + minY;
        double angle = rand.nextDouble() * 2.0 * Math.PI;
        double dist = rand.nextDouble() * max;
        double dX = Math.cos(angle) * dist;
        double dZ = Math.sin(angle) * dist;
        return center.add(dX, dY, dZ);
    }

    public static boolean randomTeleport(LivingEntity entity, Vec3 center, double min, double max, boolean effect) {
        RandomSource rand = entity.getRandom();
        for (int i = 0; i < 32; ++i) {
            Vec3 pos = EntityHelper.randomAround(rand, center, min, max);
            if (!entity.randomTeleport(pos.x(), pos.y(), pos.z(), effect)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends Entity> T randomSpawn(EntityType<T> type, ServerLevel world, BlockPos center, int min, int max, EntitySpawnReason spawn) {
        RandomSource rand = world.getRandom();
        for (int i = 0; i < 32; ++i) {
            Entity entity;
            BlockPos block = BlockPos.containing((Position)EntityHelper.randomAround(rand, Vec3.atBottomCenterOf((Vec3i)center), min, max));
            if (!SpawnPlacements.getPlacementType(type).isSpawnPositionOk((LevelReader)world, block, type) || !EntityHelper.canSpawnPosition(world, Vec3.atBottomCenterOf((Vec3i)block), type) || (entity = type.create(world, null, block, spawn, false, false)) == null) continue;
            world.addFreshEntityWithPassengers(entity);
            return (T)entity;
        }
        return null;
    }

    public static boolean canSpawnPosition(ServerLevel world, Vec3 pos, EntityType<?> type) {
        AABB bounds = type.getSpawnAABB(pos.x(), pos.y(), pos.z());
        return world.noCollision(bounds);
    }
}

